/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class LuaQRCodeUtil {
    private static Map<String, ImageIcon> QRCacheMap = new HashMap<String, ImageIcon>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon generateQRCode(String content, int width, int height) {
        Map<String, ImageIcon> map = QRCacheMap;
        synchronized (map) {
            ImageIcon imageIcon = QRCacheMap.get(content);
            if (imageIcon != null) {
                return imageIcon;
            }
        }
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            BufferedImage img = LuaQRCodeUtil.toBufferedImage(bitMatrix);
            ImageIcon imageIcon = new ImageIcon(img);
            Map<String, ImageIcon> map2 = QRCacheMap;
            synchronized (map2) {
                QRCacheMap.put(content, imageIcon);
            }
            return imageIcon;
        }
        catch (WriterException writerException) {
            return null;
        }
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

