/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util;

import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.intellij.openapi.project.Project;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class LuaNativeUtil {
    private static final String[] escapeKeys = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"};

    public static byte[] mergeBytes(byte[] data_1, byte[] data_2) {
        byte[] data = new byte[data_1.length + data_2.length];
        System.arraycopy(data_1, 0, data, 0, data_1.length);
        System.arraycopy(data_2, 0, data, data_1.length, data_2.length);
        return data;
    }

    public static byte[] getBytes(byte[] data, int start, int length) {
        byte[] data_dst = new byte[length];
        System.arraycopy(data, start, data_dst, 0, length);
        return data_dst;
    }

    public static String getIpAndPort() {
        String ip = LuaNativeUtil.getIp();
        if (ip != null) {
            return LuaNativeUtil.getIp() + ":" + LuaNativeProjectSetting.getNetPort();
        }
        return null;
    }

    public static String getIp() {
        try {
            String ip = LuaNativeUtil.getLocalHostLANAddress().getHostAddress();
            if (ip.equalsIgnoreCase("127.0.0.1")) {
                return null;
            }
            return ip;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress() && inetAddr instanceof Inet4Address) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null && candidateAddress instanceof Inet4Address) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            if (jdkSuppliedAddress instanceof Inet4Address) {
                return jdkSuppliedAddress;
            }
            return null;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static boolean isCurrentProject(Project project, String filePath) {
        if (project.isDisposed() || filePath == null) {
            return false;
        }
        System.out.println("----- >> base path: " + project.getBasePath() + "  \nentry: " + filePath + "\n");
        String rootPath = project.getBasePath().replaceFirst("/", "");
        return filePath.indexOf(rootPath) != -1;
    }

    public static String escapeSpecialWord(String str) {
        for (String key : escapeKeys) {
            if (!str.contains(key)) continue;
            str = str.replace(key, "\\" + key);
        }
        return str;
    }
}

