/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util;

import com.immomo.core.parser.config.Constants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.HashMap;
import java.util.Map;

public class LuaNativeFileUtil {
    private Project project;
    private VirtualFile srcFile;
    private boolean isShowWarning = false;
    private static Map<Project, Boolean> isShowWarningMap = new HashMap<Project, Boolean>();

    public LuaNativeFileUtil(Project project) {
        this.project = project;
    }

    private void setup() {
        Boolean isShowWarning;
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)this.project).getModules()) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                if (!file.isDirectory() || !file.getUrl().endsWith("src")) continue;
                this.srcFile = file;
                return;
            }
        }
        if (this.srcFile == null) {
            String srcUrl = "file://" + this.project.getBasePath() + "/src";
            VirtualFile srcFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(srcUrl);
            if (srcFile != null) {
                this.srcFile = srcFile;
                return;
            }
        }
        if ((isShowWarning = isShowWarningMap.get(this.project)) != null) {
            return;
        }
        isShowWarningMap.put(this.project, Boolean.TRUE);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Messages.showWarningDialog((Project)LuaNativeFileUtil.this.project, (String)"\u8bf7\u521b\u5efasrc\u4f5c\u4e3a\u5de5\u7a0b\u6839\u76ee\u5f55", (String)"\u672a\u627e\u5230src\u76ee\u5f55");
            }
        });
    }

    public VirtualFile getSrcFile() {
        if (this.srcFile == null) {
            this.setup();
        }
        return this.srcFile;
    }

    public String getSrcRelativePath(String filePath) {
        if (this.getSrcFile() == null || this.getSrcFile().getUrl() == null || !LuaNativeFileUtil.isLuaFile(filePath)) {
            return null;
        }
        String tmp = filePath.replace(this.getSrcFile().getUrl(), "");
        if (tmp != null && tmp.startsWith("/")) {
            tmp = tmp.replaceFirst("/", "");
        }
        return tmp;
    }

    public String getAbsoluteFilePath(String srcRelativePath) {
        if (this.getSrcFile() == null || this.getSrcFile().getUrl() == null || !LuaNativeFileUtil.isLuaFile(srcRelativePath)) {
            return null;
        }
        if (!srcRelativePath.startsWith("/")) {
            srcRelativePath = "/" + srcRelativePath;
        }
        return this.getSrcFile().getUrl() + srcRelativePath;
    }

    public boolean isRootFile(String filePath) {
        String tmp = this.getSrcRelativePath(filePath);
        if (tmp == null) {
            return false;
        }
        if (tmp.startsWith(Constants.DOTPREVIEW)) {
            return true;
        }
        return !tmp.contains("/");
    }

    public static boolean isLuaFile(String filePath) {
        String suffix = filePath.substring(filePath.lastIndexOf(".") + 1);
        return suffix.equals(new String("lua"));
    }
}

