/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.presenter.impl;

import com.immomo.luanative.project.toolwindow.views.impl.BasePacketView;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.immomo.luanative.util.LuaNativeFileUtil;
import com.immomo.luanative.utils.Compiler;
import com.immomo.luanative.utils.FileUtils;
import com.immomo.luanative.utils.Init;
import com.immomo.luanative.utils.ZipUtils;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class PacketViewPresenter
extends AbstractService
implements iViewPresenter {
    protected final AtomicBoolean doingTask = new AtomicBoolean(false);
    protected BasePacketView packetView;
    protected final LuaNativeFileUtil fileUtil;
    protected final File srcPath;
    protected final File outFile;
    protected final Init init;
    private SimpleDateFormat dateFormat;

    public PacketViewPresenter(Project project) {
        this.fileUtil = new LuaNativeFileUtil(project);
        this.srcPath = new File(this.fileUtil.getSrcFile().getPath());
        this.outFile = new File(this.srcPath.getParentFile(), "out");
        this.init = new Init(this.srcPath.getParentFile());
    }

    @Override
    protected boolean onStart() {
        return false;
    }

    @Override
    protected boolean onStop() {
        return false;
    }

    public <V> void setupView(V view) {
        this.packetView = (BasePacketView)view;
    }

    public boolean makeZip(final boolean compile, final String name, final int[] types) {
        if (this.doingTask.get()) {
            return false;
        }
        this.doingTask.set(true);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!compile) {
                        PacketViewPresenter.this.onlyMakeZip(name);
                    } else {
                        for (int i : types) {
                            if (PacketViewPresenter.this.compileAndMakeZip(name, i)) continue;
                            return;
                        }
                        PacketViewPresenter.this.showInfo("\u6253\u5305\u6210\u529f\uff0c\u8bf7\u68c0\u67e5out\u76ee\u5f55\u4e0b\u6587\u4ef6");
                    }
                }
                finally {
                    PacketViewPresenter.this.packetView.onFinishPacket();
                    PacketViewPresenter.this.doingTask.set(false);
                }
            }
        }).start();
        return true;
    }

    public static int[] getTypes(boolean x32, boolean x64, boolean android, boolean ios) {
        if (!x32 && !x64) {
            return null;
        }
        if (!android && !ios) {
            return null;
        }
        int[] temp = new int[4];
        int index = 0;
        if (x32 && ios) {
            temp[index++] = 0;
        }
        if (x64 && ios) {
            temp[index++] = 1;
        }
        if (x32 && android) {
            temp[index++] = 2;
        }
        if (x64 && android) {
            temp[index++] = 3;
        }
        if (index == 0) {
            return null;
        }
        if (index == 4) {
            return temp;
        }
        int[] ret2 = new int[index];
        System.arraycopy(temp, 0, ret2, 0, index);
        return ret2;
    }

    protected File copyAndCompile(int type2) {
        Compiler.setPath(this.init.getBasePath().getAbsolutePath());
        this.outFile.mkdirs();
        File temp = new File(this.outFile, "temp_" + Compiler.luacs[type2]);
        try {
            FileUtils.copyFile(this.srcPath, temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showError("\u590d\u5236src\u76ee\u5f55\u5931\u8d25\nerror:" + e.getMessage());
            FileUtils.deleteFile(temp);
            return null;
        }
        try {
            Compiler.compileDir(temp, temp, ".lua", type2);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("\u7f16\u8bd1\u5931\u8d25\nerror:" + e.getMessage());
            FileUtils.deleteFile(temp);
            return null;
        }
        return temp;
    }

    private boolean compileAndMakeZip(String prefer, int type2) {
        File temp = this.copyAndCompile(type2);
        if (temp == null) {
            return false;
        }
        String name = this.getZipName(prefer, Compiler.luacs[type2]);
        try {
            ZipUtils.makeZip(temp, new File(this.outFile, name), false);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showError("\u6253\u538b\u7f29\u5305\u5931\u8d25\nerror: " + e.getMessage());
            FileUtils.deleteFile(temp);
            FileUtils.deleteFile(new File(this.outFile, name));
            return false;
        }
        FileUtils.deleteFile(temp);
        return true;
    }

    private void onlyMakeZip(String prefer) {
        this.outFile.mkdirs();
        try {
            String name = this.getZipName(prefer, null);
            ZipUtils.makeZip(this.srcPath, new File(this.outFile, name), false);
            this.showInfo("\u6253\u538b\u7f29\u5305\u6210\u529f\n\u6587\u4ef6\u8def\u5f84: out/" + name);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showError("\u6253\u538b\u7f29\u5305\u5931\u8d25\nerror: " + e.getMessage());
        }
    }

    private String getZipName(String prefer, String plat) {
        if (prefer == null || prefer.length() == 0) {
            prefer = this.getNowDate();
        }
        if (prefer.endsWith(".zip")) {
            prefer = prefer.substring(0, prefer.length() - 4);
        }
        if (plat == null) {
            return prefer + ".zip";
        }
        return prefer + "_" + plat + ".zip";
    }

    protected String getNowDate() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("MMdd_HH-mm-ss");
        }
        return this.dateFormat.format(new Date());
    }

    protected void showInfo(String msg) {
        BasePacketView.showAlert("\u63d0\u793a", msg);
    }

    protected void showError(String msg) {
        BasePacketView.showAlert("\u9519\u8bef\u63d0\u793a", msg);
    }
}

