/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.presenter.impl;

import com.immomo.luanative.project.toolwindow.views.impl.BasePacketView;
import com.immomo.luanative.project.toolwindow.views.impl.FepView;
import com.immomo.luanative.sevice.project.presenter.impl.PacketViewPresenter;
import com.immomo.luanative.utils.FileUtils;
import com.immomo.luanative.utils.NotInstalledException;
import com.immomo.luanative.utils.ShellExecutor;
import com.immomo.luanative.utils.fep.FepConfigs;
import com.immomo.luanative.utils.fep.FepTask;
import com.immomo.luanative.utils.git.GitExecutor;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class FepPresenter
extends PacketViewPresenter
implements FepTask.Callback {
    private FepView fepView;
    private boolean gitInit;

    public FepPresenter(Project project) {
        super(project);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/usr/local/bin");
        ShellExecutor.setEnvironment(env);
        try {
            GitExecutor.init();
            this.gitInit = true;
        }
        catch (NotInstalledException e) {
            BasePacketView.showAlert("\u9519\u8bef\u63d0\u9192", "\u672a\u5b89\u88c5git\u5de5\u5177\uff0cgit\u76f8\u5173\u529f\u80fd\u4e0d\u53ef\u7528");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.gitInit = false;
            BasePacketView.showAlert("\u521d\u59cb\u5316git\u5de5\u5177\u51fa\u9519", "\u9519\u8bef\u4fe1\u606f:\n" + e.getMessage() + "\ngit\u76f8\u5173\u529f\u80fd\u4e0d\u53ef\u7528");
        }
    }

    public boolean isGitInit() {
        return this.gitInit;
    }

    @Override
    public <V> void setupView(V view) {
        super.setupView(view);
        this.fepView = (FepView)view;
    }

    public boolean doTask(String dirName, String gitUrl, FepConfigs configs, boolean compile, int type2) {
        if (this.doingTask.get()) {
            return false;
        }
        this.doingTask.set(true);
        new Thread(() -> {
            this.realTask(dirName, gitUrl, configs, compile, type2);
            this.packetView.onFinishPacket();
            this.doingTask.set(false);
        }).start();
        return true;
    }

    private void realTask(String dirName, String gitUrl, FepConfigs configs, boolean compile, int type2) {
        FepTask task;
        File temp;
        if (dirName == null) {
            dirName = this.getNowDate();
        }
        if (compile) {
            this.fepView.onStateChange("\u7f16\u8bd1\u4e2d...");
            temp = this.copyAndCompile(type2);
            if (temp == null) {
                return;
            }
            try {
                FileUtils.moveFile(temp, new File(this.outFile, dirName));
                temp = new File(temp, dirName);
                FileUtils.moveFile(new File(this.outFile, dirName), temp);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.showError("\u79fb\u52a8\u6587\u4ef6\u51fa\u9519\nerror:" + e.getMessage());
                return;
            }
        }
        this.fepView.onStateChange("\u590d\u5236\u6587\u4ef6...");
        temp = new File(this.outFile, dirName);
        try {
            FileUtils.copyFile(this.srcPath, temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showError("\u590d\u5236\u6587\u4ef6\u51fa\u9519\nerror:" + e.getMessage());
            return;
        }
        try {
            this.fepView.onStateChange("\u521d\u59cb\u5316fep...");
            task = new FepTask(gitUrl, temp, this.outFile, configs);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("Fep\u521d\u59cb\u5316\u51fa\u9519\nerror:" + e.getMessage());
            return;
        }
        task.setCallback(this);
        try {
            task.call();
            this.showInfo("\u7531\u4e8efep\u95ee\u9898\uff0c\u5e76\u4e0d\u4fdd\u8bc1\u53d1\u5e03\u6210\u529f\uff0c\u8bf7\u5728fep\u4e0a\u68c0\u67e5\u53d1\u5e03\u7ed3\u679c");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("Fep\u51fa\u9519\nerror:" + e.getMessage());
        }
        FileUtils.deleteFile(new File(this.outFile, dirName));
    }

    @Override
    public void before(String task) {
        this.fepView.onStateChange("\u6b63\u5728 " + task + " ...");
    }
}

