/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.presenter.impl;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.project.file.LuaFileChangeInfo;
import com.immomo.luanative.project.file.LuaFileInfo;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.project.toolwindow.ComboBox.ComboBoxFactory;
import com.immomo.luanative.project.toolwindow.ComboBox.iLuaNativeComboBoxItem;
import com.immomo.luanative.project.toolwindow.ComboBox.impl.ComboBoxFileItem;
import com.immomo.luanative.project.toolwindow.views.iEntryFileSettingListener;
import com.immomo.luanative.project.toolwindow.views.iEntryFileSettingView;
import com.immomo.luanative.project.toolwindow.views.impl.EntryFileSettingsView;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.broadcastchannel.LuaFileChannel;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EntryFileSettingViewPresenter
extends AbstractService
implements iViewPresenter,
iEntryFileSettingListener {
    private Project project;
    private iEntryFileSettingView myView;
    private iBroadcastChannel entryFileChannel;
    private iBroadcastChannel fileChannel;
    private Map<String, ComboBoxFileItem> comboBoxItemMap = new HashMap<String, ComboBoxFileItem>();
    static String entryfilePath;

    public EntryFileSettingViewPresenter(Project project) {
        this.project = project;
    }

    @Override
    protected boolean onStart() {
        this.openChannel();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannel();
        return true;
    }

    public <iEntryFileSettingView> void setupView(iEntryFileSettingView view) {
        this.myView = (iEntryFileSettingView)view;
        if (this.myView != null) {
            this.start();
            this.entryFileChannel.postMessage("REQUEST_LIST", null);
        }
    }

    @Override
    public void didSelected(iLuaNativeComboBoxItem item, String params) {
        ComboBoxFileItem fileItem = (ComboBoxFileItem)item;
        fileItem.getFileInfo().setParams(params);
        this.entryFileChannel.postMessage("SELECTED", fileItem.getFileInfo());
        this.entryFileHasUpdated(fileItem.getFileInfo());
    }

    @Override
    public void didDeselected(iLuaNativeComboBoxItem item) {
        ComboBoxFileItem fileItem = (ComboBoxFileItem)item;
        this.entryFileChannel.postMessage("DESELECTED", fileItem.getFileInfo());
    }

    @Override
    public boolean isAutoSyncOpen() {
        return LuaNativeProjectSetting.isAutoSyncOpen();
    }

    @Override
    public void setAutoSync(boolean isOpen) {
        if (isOpen == this.isAutoSyncOpen()) {
            return;
        }
        LuaNativeProjectSetting.setAutoSync(isOpen);
        if (isOpen) {
            this.fileChannel.postMessage("OPEN_AUTO_SYNC", null);
        }
    }

    @Override
    public void forceReload(String params) {
        this.fileChannel.postMessage("FORCE_SYNC", params);
    }

    @Override
    public void openLuaCodeCoverage(boolean isOpen) {
        if (isOpen == this.isOpenLuaCoverage()) {
            return;
        }
        this.fileChannel.postMessage("LUA_CODE_COVERAGE", isOpen);
    }

    @Override
    public boolean isOpenLuaCoverage() {
        if (entryfilePath == null) {
            return false;
        }
        VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(entryfilePath);
        Document doc = FileDocumentManager.getInstance().getDocument(vf);
        int index = doc.getText().indexOf("local runner = require('MLNCodeCoverage.luacov')\nfunction gencoveragereport() runner.shutdown() end\n");
        return index != -1;
    }

    @Override
    public void clearPreviousCoverageResult(boolean shouldClear) {
        if (shouldClear == this.isClearPreviousCoverage()) {
            return;
        }
        this.fileChannel.postMessage("CLEAR_PREVIOUS_COVERAGE_RESULT", shouldClear);
    }

    @Override
    public boolean isClearPreviousCoverage() {
        if (entryfilePath == null) {
            return false;
        }
        VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(entryfilePath);
        Document doc = FileDocumentManager.getInstance().getDocument(vf);
        int index = doc.getText().indexOf("MLNCodeCovClearPreviousResult{'luacov.stats.out', 'luacov.report.out', 'luacov.summary.out', 'cobertura.report.out'}\n");
        return index != -1;
    }

    @Override
    public void generateCoverageReport() {
        if (entryfilePath == null) {
            return;
        }
        this.fileChannel.postMessage("GENE_COVERAGE_REPORT_ACTION", null);
    }

    @Override
    public void generateDetailCoverageReport() {
        String userPath = System.getProperty("user.home");
        String dirPath = userPath + "/Library/MLNCodeCovResources";
        String pyPath = dirPath + "/pyfiles/gendetail.py";
        String shellPath = dirPath + "/pyfiles/gendetail.sh";
        File pyFile = new File(pyPath);
        if (!pyFile.exists()) {
            System.out.print("\u751f\u6210\u8be6\u7ec6\u62a5\u544a\u7684python\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        try {
            Runtime.getRuntime().exec("chmod a+x " + pyPath + " " + shellPath);
            String srcPath = "" + this.project.getBasePath() + "/src";
            String cmd = shellPath + " " + pyPath + " " + srcPath;
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            System.out.print(e.toString());
        }
    }

    private void entryFileHasUpdated(LuaFileInfo fileInfo) {
        entryfilePath = fileInfo.getFilePath();
        EntryFileSettingsView fileView = (EntryFileSettingsView)this.myView;
        fileView.entryFileIsUpdated();
    }

    private void openChannel() {
        this.fileChannel = LuaFileChannel.getInstance(this.project);
        this.entryFileChannel = LuaFileChannel.getEntryFileInstance(this.project);
        this.entryFileChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("ADD")) {
                    LuaFileInfo msg = (LuaFileInfo)event.getData();
                    EntryFileSettingViewPresenter.this.addEntryFile(msg);
                } else if (event.getType().equals("REMOVE")) {
                    LuaFileInfo msg = (LuaFileInfo)event.getData();
                    EntryFileSettingViewPresenter.this.removeEntryFile(msg);
                } else if (event.getType().equals("CHANGE")) {
                    LuaFileChangeInfo msg = (LuaFileChangeInfo)event.getData();
                    EntryFileSettingViewPresenter.this.changeEntryFile(msg);
                } else if (event.getType().equals("RESPONSE_LIST")) {
                    ArrayList messageArrayList = (ArrayList)event.getData();
                    for (LuaFileInfo msg : messageArrayList) {
                        EntryFileSettingViewPresenter.this.addEntryFile(msg);
                    }
                }
            }
        });
    }

    private void closeChannel() {
        if (this.entryFileChannel != null) {
            this.entryFileChannel.close();
        }
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }

    private void addEntryFile(final LuaFileInfo msg) {
        if (this.hasItem(msg)) {
            return;
        }
        final ComboBoxFileItem item = this.buildItem(msg);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EntryFileSettingViewPresenter.this.myView != null && msg != null) {
                    EntryFileSettingViewPresenter.this.myView.addEntryFile(item);
                }
            }
        });
    }

    private void removeEntryFile(final LuaFileInfo msg) {
        final ComboBoxFileItem item = this.removeItem(msg);
        if (item == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EntryFileSettingViewPresenter.this.myView != null && msg != null) {
                    EntryFileSettingViewPresenter.this.myView.removeEntryFile(item);
                }
            }
        });
    }

    private void changeEntryFile(final LuaFileChangeInfo msg) {
        final ComboBoxFileItem item = this.getItem(msg.getOldEntryFileInfo());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (item != null) {
                    item.updateFileInfo(msg.getNewEntryFileInfo());
                }
            }
        });
    }

    private ComboBoxFileItem getItem(LuaFileInfo fileInfo) {
        return this.comboBoxItemMap.get(fileInfo.getFilePath());
    }

    private boolean hasItem(LuaFileInfo fileInfo) {
        return this.comboBoxItemMap.containsKey(fileInfo);
    }

    private ComboBoxFileItem buildItem(LuaFileInfo fileInfo) {
        ComboBoxFileItem item = (ComboBoxFileItem)ComboBoxFactory.getInstance(fileInfo, true);
        this.comboBoxItemMap.put(fileInfo.getFilePath(), item);
        return item;
    }

    private ComboBoxFileItem removeItem(LuaFileInfo fileInfo) {
        ComboBoxFileItem item = this.comboBoxItemMap.get(fileInfo.getFilePath());
        this.comboBoxItemMap.remove(fileInfo);
        return item;
    }
}

