/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.presenter.impl;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.channel.DeviceChannel;
import com.immomo.luanative.project.toolwindow.ComboBox.impl.ComboBoxDeviceItem;
import com.immomo.luanative.project.toolwindow.views.iDeviceSettingView;
import com.immomo.luanative.project.toolwindow.views.iDevicesSettingListener;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DevicesSettingsViewPresenter
extends AbstractService
implements iViewPresenter,
iDevicesSettingListener {
    private Project project;
    private iDeviceSettingView myView;
    private iBroadcastChannel deviceProjectChannel;
    private Set<BaseDevice> avaliableDevices = new HashSet<BaseDevice>();

    public DevicesSettingsViewPresenter(Project project) {
        this.project = project;
    }

    @Override
    protected boolean onStart() {
        this.openChannel();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannel();
        return true;
    }

    private void openChannel() {
        this.deviceProjectChannel = DeviceChannel.getInstance(this.project);
        this.deviceProjectChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(final iMessageEvent event) {
                if (event.getType().equals("AVALIABLE")) {
                    BaseDevice device = (BaseDevice)event.getData();
                    DevicesSettingsViewPresenter.this.addDevice(device);
                } else if (event.getType().equals("UNAVALIABLE")) {
                    BaseDevice device = (BaseDevice)event.getData();
                    DevicesSettingsViewPresenter.this.removeDevice(device);
                } else if (event.getType().equals("SYNC_AVALIABLE_LIST")) {
                    List deviceList = (List)event.getData();
                    DevicesSettingsViewPresenter.this.addDeviceList(deviceList);
                } else if (event.getType().equals("FAIL_TO_SELECTED") && DevicesSettingsViewPresenter.this.myView != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("~~~~(>_<)~~~~\u545c\u545c~" + Thread.currentThread());
                            BaseDevice device = (BaseDevice)event.getData();
                            if (device.getOsType().equals("iOS")) {
                                DevicesSettingsViewPresenter.this.myView.failToSelectIOS(ComboBoxDeviceItem.getInstance(device));
                            } else {
                                DevicesSettingsViewPresenter.this.myView.failToSelectAndroid(ComboBoxDeviceItem.getInstance(device));
                            }
                        }
                    });
                }
            }
        });
    }

    private void addDevice(final BaseDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DevicesSettingsViewPresenter.this.myView != null && device != null) {
                    if (DevicesSettingsViewPresenter.this.avaliableDevices.contains(device)) {
                        return;
                    }
                    DevicesSettingsViewPresenter.this.avaliableDevices.add(device);
                    System.out.println("\ud83d\ude06addDevice[" + device.getOsType() + " " + device.getModel() + "]");
                    if (device.isIOS()) {
                        DevicesSettingsViewPresenter.this.myView.addIOSDeviece(ComboBoxDeviceItem.getInstance(device));
                    } else {
                        DevicesSettingsViewPresenter.this.myView.addAndroidDeviece(ComboBoxDeviceItem.getInstance(device));
                    }
                }
            }
        });
    }

    private void closeChannel() {
        if (this.deviceProjectChannel != null) {
            this.deviceProjectChannel.close();
            this.deviceProjectChannel = null;
        }
    }

    private void addDeviceList(final List<BaseDevice> deviceList) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DevicesSettingsViewPresenter.this.myView != null && deviceList != null) {
                    ArrayList<ComboBoxDeviceItem> items = new ArrayList<ComboBoxDeviceItem>();
                    for (BaseDevice device : deviceList) {
                        if (DevicesSettingsViewPresenter.this.avaliableDevices.contains(device)) continue;
                        DevicesSettingsViewPresenter.this.avaliableDevices.add(device);
                        System.out.println("\ud83d\ude06addDeviceList[" + device.getOsType() + " " + device.getModel() + "]");
                        items.add(ComboBoxDeviceItem.getInstance(device));
                    }
                    if (items.size() > 0) {
                        if (((BaseDevice)deviceList.get(0)).isIOS()) {
                            DevicesSettingsViewPresenter.this.myView.addIOSDevieceList(items);
                        } else {
                            DevicesSettingsViewPresenter.this.myView.addAndroidDevieceList(items);
                        }
                    }
                }
            }
        });
    }

    private void removeDevice(final BaseDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DevicesSettingsViewPresenter.this.myView != null && device != null) {
                    System.out.println("\ud83d\ude06removeDevice[" + device.getOsType() + " " + device.getModel() + "]");
                    DevicesSettingsViewPresenter.this.avaliableDevices.remove(device);
                    if (device.isIOS()) {
                        DevicesSettingsViewPresenter.this.myView.removeIOSDevice(ComboBoxDeviceItem.getInstance(device));
                    } else {
                        DevicesSettingsViewPresenter.this.myView.removeAndroidDevice(ComboBoxDeviceItem.getInstance(device));
                    }
                    DevicesSettingsViewPresenter.this.deviceDisconnected(device);
                }
            }
        });
    }

    public <iDeviceSettingView> void setupView(iDeviceSettingView view) {
        this.myView = (iDeviceSettingView)view;
        if (this.myView != null) {
            this.start();
            this.deviceProjectChannel.postMessage("REQUEST_AVALIABLE_LIST", null);
        }
    }

    @Override
    public void iOSDeviceDidSelected(ComboBoxDeviceItem device) {
        this.deviceSelected(device.getDevice());
    }

    @Override
    public void iOSDeviceDidDeselected(ComboBoxDeviceItem device) {
        this.deviceDisconnected(device.getDevice());
    }

    @Override
    public void androidDeviceDidSelected(ComboBoxDeviceItem device) {
        this.deviceSelected(device.getDevice());
    }

    @Override
    public void androidDeviceDidDeselected(ComboBoxDeviceItem device) {
        this.deviceDisconnected(device.getDevice());
    }

    private void deviceSelected(BaseDevice device) {
        if (device == null) {
            return;
        }
        if (this.deviceProjectChannel != null) {
            this.deviceProjectChannel.postMessage("SELECTED", device);
        }
    }

    private void deviceDisconnected(BaseDevice device) {
        if (device == null) {
            return;
        }
        if (this.deviceProjectChannel != null) {
            this.deviceProjectChannel.postMessage("DESELECTED", device);
        }
    }
}

