/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.presenter.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.channel.ClientChannel;
import com.immomo.luanative.client.channel.MessageChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.codec.protobuf.PBCoverageDetailCommand;
import com.immomo.luanative.codec.protobuf.PBCoverageSummaryCommand;
import com.immomo.luanative.codec.protobuf.PBErrorCommand;
import com.immomo.luanative.codec.protobuf.PBLogCommand;
import com.immomo.luanative.project.handler.FileLinkHandler;
import com.immomo.luanative.project.toolwindow.ComboBox.impl.ComboBoxDeviceItem;
import com.immomo.luanative.project.toolwindow.views.iConsoleView;
import com.immomo.luanative.project.toolwindow.views.iConsoleViewListener;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.immomo.luanative.util.LuaNativeUtil;
import com.immomo.luanative.util.consolefilter.ConsoleFilterFactory;
import com.immomo.luanative.util.consolefilter.iConsoleFilter;
import com.immomo.luanative.util.document.LuaNativeDocumentUtil;
import com.immomo.luanative.util.search.ConsoleSearchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.StyledDocument;

public class ConsoleViewPresenter
extends AbstractService
implements iViewPresenter,
iConsoleViewListener {
    private Project project;
    private iBroadcastChannel clientProjectChannel;
    private iConsoleView myView;
    private Map<String, iBroadcastChannel> clientMap = new HashMap<String, iBroadcastChannel>();
    private Map<String, iConsoleFilter> filterChainMap = new HashMap<String, iConsoleFilter>();
    private Map<String, List<Object>> allInfos = new HashMap<String, List<Object>>();
    private Map<String, ConsoleSearchUtil> searchUtilMap = new HashMap<String, ConsoleSearchUtil>();

    public ConsoleViewPresenter(Project project) {
        this.project = project;
    }

    @Override
    public <T> void setupView(T view) {
        this.myView = (iConsoleView)view;
        if (this.myView != null) {
            this.openChannel();
        }
    }

    @Override
    protected boolean onStart() {
        this.clientProjectChannel = ClientChannel.getInstance(this.project);
        return true;
    }

    @Override
    protected boolean onStop() {
        if (this.clientProjectChannel != null) {
            this.clientProjectChannel.close();
            this.clientProjectChannel = null;
        }
        return true;
    }

    private void openChannel() {
        this.clientProjectChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(final iMessageEvent event) {
                if (event.getType().equals("OPEN")) {
                    if (ConsoleViewPresenter.this.myView != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                iClient client = (iClient)event.getData();
                                ConsoleViewPresenter.this.myView.addConsoleContainerView(client.getDevice().getSerialNumber(), ComboBoxDeviceItem.getInstance(client.getDevice()).toString());
                                ConsoleViewPresenter.this.myView.addMouseListener(new FileLinkHandler(ConsoleViewPresenter.this.project));
                                ConsoleViewPresenter.this.openChannelForClient(client);
                            }
                        });
                    }
                } else if (event.getType().equals("CLOSE") && ConsoleViewPresenter.this.myView != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            iClient client = (iClient)event.getData();
                            ConsoleViewPresenter.this.myView.removeConsoleContainerView(client.getDevice().getSerialNumber());
                            ConsoleViewPresenter.this.closeChannelForClient(client);
                            ConsoleViewPresenter.this.filterChainMap.remove(client.getDevice().getSerialNumber());
                        }
                    });
                }
            }
        });
    }

    private void openChannelForClient(iClient client) {
        iBroadcastChannel commandChannel = MessageChannel.getRecieveInstance(client);
        commandChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("LOG")) {
                    Object data = event.getData();
                    if (data != null) {
                        ConsoleViewPresenter.this.doLog((PBLogCommand.pblogcommand)data);
                    }
                } else if (event.getType().equals("ERROR")) {
                    Object data = event.getData();
                    if (data != null) {
                        ConsoleViewPresenter.this.doError((PBErrorCommand.pberrorcommand)data);
                    }
                } else if (event.getType().equals("COVERAGE_SUMMARY")) {
                    Object data = event.getData();
                    PBCoverageSummaryCommand.pbcoveragesummarycommand covCmd = (PBCoverageSummaryCommand.pbcoveragesummarycommand)data;
                    ConsoleViewPresenter.this.writeSummaryDataToJSFile(covCmd);
                } else if (event.getType().equals("COVERAGE_DETAIL")) {
                    Object data = event.getData();
                    PBCoverageDetailCommand.pbcoveragedetailcommand detailCmd = (PBCoverageDetailCommand.pbcoveragedetailcommand)data;
                    ConsoleViewPresenter.this.writeDetailDataToFile(detailCmd);
                }
            }
        });
        this.clientMap.put(client.getDevice().getSerialNumber(), commandChannel);
    }

    private void closeChannelForClient(iClient client) {
        iBroadcastChannel commandChannel = this.clientMap.get(client.getDevice().getSerialNumber());
        if (commandChannel != null) {
            commandChannel.close();
            this.clientMap.remove(client.getDevice().getSerialNumber());
        }
    }

    private void doLog(final PBLogCommand.pblogcommand cmd) {
        if (!this.isCurrentProject(cmd.getEntryFilePath())) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConsoleViewPresenter.this.myView != null) {
                    StyledDocument sd;
                    System.out.println("Presenter \u8981\u6253\u5370\u4e86");
                    ConsoleViewPresenter.this.addInfo(cmd.getBasecommand().getSerialNumber(), cmd);
                    iConsoleFilter filterChain = ConsoleViewPresenter.this.getFilterChain(cmd.getBasecommand().getSerialNumber());
                    PBLogCommand.pblogcommand retcmd = filterChain.put(cmd);
                    if (retcmd != null && (sd = ConsoleViewPresenter.this.myView.getStyledDocument(cmd.getBasecommand().getSerialNumber())) != null) {
                        LuaNativeDocumentUtil.addLog(sd, cmd);
                        ConsoleViewPresenter.this.getConsoleSearchUtil(cmd.getBasecommand().getSerialNumber()).search(sd);
                        ConsoleViewPresenter.this.updateSearchResult(cmd.getBasecommand().getSerialNumber());
                    }
                }
            }
        });
    }

    private void doError(final PBErrorCommand.pberrorcommand cmd) {
        if (!this.isCurrentProject(cmd.getEntryFilePath())) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConsoleViewPresenter.this.myView != null) {
                    StyledDocument sd;
                    System.out.println("Presenter \u8981\u6253\u5370\u4e86");
                    ConsoleViewPresenter.this.addInfo(cmd.getBasecommand().getSerialNumber(), cmd);
                    iConsoleFilter filterChain = ConsoleViewPresenter.this.getFilterChain(cmd.getBasecommand().getSerialNumber());
                    PBErrorCommand.pberrorcommand retcmd = filterChain.put(cmd);
                    if (retcmd != null && (sd = ConsoleViewPresenter.this.myView.getStyledDocument(cmd.getBasecommand().getSerialNumber())) != null) {
                        LuaNativeDocumentUtil.addError(sd, cmd);
                        ConsoleViewPresenter.this.getConsoleSearchUtil(cmd.getBasecommand().getSerialNumber()).search(sd);
                        ConsoleViewPresenter.this.updateSearchResult(cmd.getBasecommand().getSerialNumber());
                    }
                }
            }
        });
    }

    private void writeSummaryDataToJSFile(PBCoverageSummaryCommand.pbcoveragesummarycommand cmd) {
        ByteString fileData = cmd.toBuilder().getFileData();
        if (fileData != null) {
            File jsFile;
            String userPath = System.getProperty("user.home");
            String dirPath = userPath + "/Library/MLNCodeCovResources";
            String htmlPath = dirPath + "/mlncodecoverage.html";
            String jsPath = dirPath + "/covdata.js";
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                dirFile.mkdir();
            }
            if (!(jsFile = new File(jsPath)).exists()) {
                try {
                    jsFile.createNewFile();
                }
                catch (Exception e) {
                    System.out.print(e.toString());
                }
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(jsPath));
                out.write(fileData.toStringUtf8());
                out.close();
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            File htmlFile = new File(htmlPath);
            if (!htmlFile.exists()) {
                try {
                    InputStream in = this.getClass().getResourceAsStream("/com/immomo/luanative/project/toolwindow/html/mlncodecoverage.html");
                    FileOutputStream out = new FileOutputStream(htmlFile);
                    byte[] bf = new byte[0x100000];
                    int readSize = 0;
                    while ((readSize = in.read(bf)) > 0) {
                        out.write(bf, 0, readSize);
                    }
                    Runtime.getRuntime().exec("chmod a+x " + htmlFile);
                }
                catch (Exception e) {
                    System.out.print(e.toString());
                }
            }
            this.myView.updateCodeCoverageSummary("file://" + htmlPath);
            this.createDetailGeneraterPythonFileIfNeeded(dirPath);
        }
    }

    private void writeDetailDataToFile(PBCoverageDetailCommand.pbcoveragedetailcommand cmd) {
        ByteString fileData = cmd.toBuilder().getFileData();
        if (fileData != null) {
            File detailFile;
            String userPath = System.getProperty("user.home");
            String dirPath = userPath + "/Library/MLNCodeCovResources";
            String detailPath = dirPath + "/cobertura.report.out";
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                dirFile.mkdir();
            }
            if (!(detailFile = new File(detailPath)).exists()) {
                try {
                    detailFile.createNewFile();
                }
                catch (Exception e) {
                    System.out.print(e.toString());
                }
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(detailPath));
                out.write(fileData.toStringUtf8());
                out.close();
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        }
    }

    private void createDetailGeneraterPythonFileIfNeeded(String dirPath) {
        String shellPath = dirPath + "/pyfiles/gendetail.sh";
        File shellFile = new File(shellPath);
        if (!shellFile.exists()) {
            String jarPath = this.getClass().getResource("").getPath();
            int end = jarPath.indexOf(".jar!");
            if (end != -1) {
                jarPath = jarPath.substring(5, end + 4);
                jarPath = jarPath.replaceAll("%20", "\\\\ ");
            }
            try {
                String tempPath = dirPath + "/temp";
                String mkdir = "mkdir " + tempPath + "; ";
                String cpcmd = "cp " + jarPath + " " + tempPath + "; ";
                String cdcmd = "cd " + tempPath + "; ";
                String jarcmd = "jar xvf MomoLuaNative.jar; ";
                String mvcmd = "mv ./pyfiles ../;";
                String delete = "rm -rf ../temp;";
                String back = "cd -";
                String[] cmd = new String[]{"/bin/sh", "-c", "" + mkdir + cpcmd + cdcmd + jarcmd + mvcmd + mvcmd + delete + back};
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e) {
                System.out.print(e.toString());
            }
        }
    }

    @Override
    public void onSearchKeyChanged(String consoleViewKey, String key) {
        if (this.myView != null) {
            this.myView.clearAll(consoleViewKey);
        }
        this.reprocessAllInfo(consoleViewKey);
        StyledDocument sd = this.myView.getStyledDocument(consoleViewKey);
        this.getConsoleSearchUtil(consoleViewKey).search(sd, key);
        this.updateSearchResult(consoleViewKey);
    }

    @Override
    public void onSearchGetReturn(String consoleViewKey, String key) {
        this.getConsoleSearchUtil(consoleViewKey).scrollToNext(consoleViewKey);
        this.updateSearchResult(consoleViewKey);
    }

    @Override
    public void onFilterChanged(String consoleViewKey, int type2, String key) {
        if (this.myView != null) {
            this.myView.clearAll(consoleViewKey);
        }
        iConsoleFilter filterChain = ConsoleFilterFactory.getFilterChain(type2, key);
        this.filterChainMap.put(consoleViewKey, filterChain);
        this.reprocessAllInfo(consoleViewKey);
        StyledDocument sd = this.myView.getStyledDocument(consoleViewKey);
        this.getConsoleSearchUtil(consoleViewKey).search(sd);
        this.updateSearchResult(consoleViewKey);
    }

    @Override
    public void onClearAll(String consoleViewKey) {
        iConsoleFilter filterChain = this.filterChainMap.get(consoleViewKey);
        List<Object> infos = this.allInfos.get(consoleViewKey);
        if (infos == null) {
            return;
        }
        ArrayList<Object> infosTmp = new ArrayList<Object>(infos);
        for (Object e : infosTmp) {
            if (filterChain == null) {
                infos.remove(e);
                continue;
            }
            Object ret2 = filterChain.put(e);
            if (ret2 == null) continue;
            infos.remove(e);
        }
    }

    private void reprocessAllInfo(String consoleViewKey) {
        iConsoleFilter filterChain = this.filterChainMap.get(consoleViewKey);
        List<Object> infos = this.allInfos.get(consoleViewKey);
        if (infos == null) {
            return;
        }
        for (Object obj : infos) {
            StyledDocument sd;
            GeneratedMessageV3 cmd;
            Object ret2 = filterChain.put(obj);
            if (ret2 == null) continue;
            if (ret2 instanceof PBErrorCommand.pberrorcommand) {
                cmd = (PBErrorCommand.pberrorcommand)ret2;
                sd = this.myView.getStyledDocument(cmd.getBasecommand().getSerialNumber());
                if (sd == null) continue;
                LuaNativeDocumentUtil.addError(sd, (PBErrorCommand.pberrorcommand)cmd);
                continue;
            }
            if (!(ret2 instanceof PBLogCommand.pblogcommand) || (sd = this.myView.getStyledDocument((cmd = (PBLogCommand.pblogcommand)ret2).getBasecommand().getSerialNumber())) == null) continue;
            LuaNativeDocumentUtil.addLog(sd, (PBLogCommand.pblogcommand)cmd);
        }
    }

    private void updateSearchResult(String consoleViewKey) {
        String result = null;
        int count = this.getConsoleSearchUtil(consoleViewKey).getCurrentCount();
        if (count > 0) {
            int idx = this.getConsoleSearchUtil(consoleViewKey).getCurrentIndex();
            result = " " + idx + " / " + count + " ";
        }
        this.myView.updateSearchResult(consoleViewKey, result);
    }

    private <T> void addInfo(String consoleViewKey, T info) {
        List<Object> infos = this.allInfos.get(consoleViewKey);
        if (infos == null) {
            infos = new ArrayList<Object>();
            this.allInfos.put(consoleViewKey, infos);
        }
        infos.add(info);
    }

    private iConsoleFilter getFilterChain(String key) {
        iConsoleFilter filterChain = this.filterChainMap.get(key);
        if (filterChain == null && this.myView != null) {
            filterChain = ConsoleFilterFactory.getFilterChain(this.myView.getFilterType(key), this.myView.getFilterKey(key));
            this.filterChainMap.put(key, filterChain);
        }
        return filterChain;
    }

    private ConsoleSearchUtil getConsoleSearchUtil(String key) {
        ConsoleSearchUtil util = this.searchUtilMap.get(key);
        if (util == null) {
            util = new ConsoleSearchUtil(this.myView);
            this.searchUtilMap.put(key, util);
        }
        return util;
    }

    private boolean isCurrentProject(String entryFilePath) {
        return LuaNativeUtil.isCurrentProject(this.project, entryFilePath);
    }
}

