/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.file.entryfile;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.MessageEventFactory;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.project.file.LuaEntryFilePersistentHelper;
import com.immomo.luanative.project.file.LuaFileChangeInfo;
import com.immomo.luanative.project.file.LuaFileInfo;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.broadcastchannel.LuaFileChannel;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorChangeInfo;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorInfo;
import com.immomo.luanative.util.LuaNativeFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;

public class LuaEntryFileManager
extends AbstractService {
    private Project project;
    private LuaNativeFileUtil fileUtil;
    private iBroadcastChannel entryFileChannel;
    private iBroadcastChannel fileChannel;
    private LuaFileInfo selectedEntryFileInfo;

    public LuaEntryFileManager(Project project) {
        this.project = project;
        this.fileUtil = new LuaNativeFileUtil(project);
    }

    public void addEntryFile(String filePath) {
        if (!this.isEntryFile(filePath)) {
            LuaEntryFilePersistentHelper ph = this.getEntryFileHelper();
            if (ph != null) {
                this.getEntryFileHelper().addEntryFile(filePath);
            }
            this.postMessage("ADD", filePath);
        }
    }

    public void removeEntryFile(String filePath) {
        if (this.isEntryFile(filePath)) {
            LuaEntryFilePersistentHelper ph = this.getEntryFileHelper();
            if (ph != null) {
                this.getEntryFileHelper().removeEntryFile(filePath);
            }
            this.postMessage("REMOVE", filePath);
        }
    }

    public boolean isEntryFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        LuaEntryFilePersistentHelper ph = this.getEntryFileHelper();
        if (ph != null) {
            return this.getEntryFileHelper().isEntryFile(filePath);
        }
        return false;
    }

    public LuaFileInfo getSelectedEntryFileInfo() {
        return this.selectedEntryFileInfo;
    }

    @Override
    protected boolean onStart() {
        this.openChannels();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannels();
        return true;
    }

    private void openChannels() {
        this.entryFileChannel = LuaFileChannel.getEntryFileInstance(this.project);
        this.entryFileChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("REQUEST_LIST")) {
                    iMessageEvent msgEvent = MessageEventFactory.getInstance("RESPONSE_LIST", LuaEntryFileManager.this.getSrcRelativeEntryFilePaths());
                    LuaEntryFileManager.this.entryFileChannel.postMessage(msgEvent);
                } else if (event.getType().equals("SELECTED")) {
                    LuaEntryFileManager.this.selectedEntryFileInfo = (LuaFileInfo)event.getData();
                }
            }
        });
        this.fileChannel = LuaFileChannel.getInstance(this.project);
        this.fileChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("FILE_RENAME")) {
                    LuaFileRefactorChangeInfo info = (LuaFileRefactorChangeInfo)event.getData();
                    LuaEntryFileManager.this.change(info.getNewFilePath(), info.getOldFilePath());
                } else if (event.getType().equals("FILE_DELETE")) {
                    LuaFileRefactorInfo info = (LuaFileRefactorInfo)event.getData();
                    if (LuaEntryFileManager.this.selectedEntryFileInfo != null && LuaEntryFileManager.this.selectedEntryFileInfo.getFilePath().equals(info.getFilePath())) {
                        LuaEntryFileManager.this.selectedEntryFileInfo = null;
                    }
                    LuaEntryFileManager.this.removeEntryFile(info.getFilePath());
                } else if (event.getType().equals("FILE_MOVE")) {
                    LuaFileRefactorChangeInfo info = (LuaFileRefactorChangeInfo)event.getData();
                    LuaEntryFileManager.this.change(info.getNewFilePath(), info.getOldFilePath());
                } else if (event.getType().equals("FORCE_SYNC")) {
                    String params = (String)event.getData();
                    if (LuaEntryFileManager.this.selectedEntryFileInfo != null) {
                        LuaEntryFileManager.this.selectedEntryFileInfo.setParams(params);
                    }
                }
            }
        });
    }

    private void closeChannels() {
        if (this.entryFileChannel != null) {
            this.entryFileChannel.close();
        }
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }

    private ArrayList<LuaFileInfo> getSrcRelativeEntryFilePaths() {
        LuaEntryFilePersistentHelper ph = this.getEntryFileHelper();
        if (ph == null) {
            return new ArrayList<LuaFileInfo>();
        }
        ArrayList<String> entryFilePathsCopy = new ArrayList<String>(ph.getEntryFileList());
        ArrayList<LuaFileInfo> entryFileInfos = new ArrayList<LuaFileInfo>(ph.getEntryFileList().size());
        for (String filePath : entryFilePathsCopy) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(filePath);
            if (file != null) {
                String relativePath = this.fileUtil.getSrcRelativePath(filePath);
                if (relativePath == null) continue;
                LuaFileInfo msg = new LuaFileInfo(filePath, relativePath, null);
                entryFileInfos.add(msg);
                continue;
            }
            ph.removeEntryFile(filePath);
        }
        return entryFileInfos;
    }

    private void change(String filePath, String oldFilePath) {
        LuaEntryFilePersistentHelper helper;
        if (oldFilePath == null) {
            return;
        }
        if (!this.fileUtil.isRootFile(filePath)) {
            if (this.selectedEntryFileInfo != null && this.selectedEntryFileInfo.getFilePath().equals(oldFilePath)) {
                this.selectedEntryFileInfo = null;
            }
            this.removeEntryFile(oldFilePath);
            return;
        }
        if (this.selectedEntryFileInfo != null && this.selectedEntryFileInfo.getFilePath().equals(oldFilePath)) {
            this.selectedEntryFileInfo.setFilePath(filePath);
            this.selectedEntryFileInfo.setRelativeFilePath(this.fileUtil.getSrcRelativePath(filePath));
        }
        if ((helper = this.getEntryFileHelper()) != null) {
            helper.changeEntryFile(filePath, oldFilePath);
        }
        this.postChangeMessage("CHANGE", filePath, oldFilePath);
    }

    private void postMessage(String action, String filePath) {
        LuaFileInfo efm = new LuaFileInfo(filePath, this.fileUtil.getSrcRelativePath(filePath), null);
        iMessageEvent msgEvent = MessageEventFactory.getInstance(action, efm);
        this.entryFileChannel.postMessage(msgEvent);
    }

    private void postChangeMessage(String action, String filePath, String oldFilePath) {
        LuaFileInfo oldInfo = new LuaFileInfo(oldFilePath, this.fileUtil.getSrcRelativePath(oldFilePath), null);
        LuaFileInfo newInfo = new LuaFileInfo(filePath, this.fileUtil.getSrcRelativePath(filePath), null);
        LuaFileChangeInfo efm = new LuaFileChangeInfo(oldInfo, newInfo);
        iMessageEvent msgEvent = MessageEventFactory.getInstance(action, efm);
        this.entryFileChannel.postMessage(msgEvent);
    }

    private LuaEntryFilePersistentHelper getEntryFileHelper() {
        return LuaEntryFilePersistentHelper.getInstance(this.project);
    }
}

