/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.file;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.project.broadcastchannel.LuaFileChannel;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorChangeInfo;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorInfo;
import com.immomo.luanative.util.LuaNativeFileUtil;
import com.immomo.luanative.util.LuaNativeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;

public class LuaVirtualFileListenerService
extends AbstractService
implements VirtualFileListener {
    private Project project;
    private iBroadcastChannel fileChannel;

    public LuaVirtualFileListenerService(Project project) {
        this.project = project;
    }

    @Override
    protected boolean onStart() {
        this.openChannels();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
        return true;
    }

    @Override
    protected boolean onStop() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        this.closeChannels();
        return true;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            LuaVirtualFileListenerService.$$$reportNull$$$0(0);
        }
        if (this.isCurrentProject(event.getFile().getUrl()) && this.isSingleFileVisiable(event.getFile())) {
            System.out.println(">> Created: " + event.getFile().getUrl());
            this.fileChannel.postMessage("FILE_CREATE", new LuaFileRefactorInfo(event.getFile().getUrl(), event.getFile().isDirectory()));
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            LuaVirtualFileListenerService.$$$reportNull$$$0(1);
        }
        String newFilePath = event.getFile().getUrl();
        if (event.getPropertyName().equals("name") && this.isCurrentProject(newFilePath) && this.isFileVisiable(event.getFile())) {
            System.out.println(">> RENAME: " + newFilePath);
            String oldFilePath = newFilePath.replace((String)event.getNewValue(), (String)event.getOldValue());
            this.fileChannel.postMessage("FILE_RENAME", new LuaFileRefactorChangeInfo(oldFilePath, newFilePath, event.getFile().isDirectory()));
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            LuaVirtualFileListenerService.$$$reportNull$$$0(2);
        }
        if (this.isCurrentProject(event.getFile().getUrl()) && this.isFileVisiable(event.getFile())) {
            System.out.println(">> Deleted: " + event.getFile().getUrl());
            this.fileChannel.postMessage("FILE_DELETE", new LuaFileRefactorInfo(event.getFile().getUrl(), event.getFile().isDirectory()));
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            LuaVirtualFileListenerService.$$$reportNull$$$0(3);
        }
        if (this.isCurrentProject(event.getFile().getUrl()) && this.isFileVisiable(event.getFile())) {
            System.out.println(">> Moved: " + event.getFile().getUrl());
            String newFilePath = event.getFile().getUrl();
            String oldFilePath = event.getOldParent().getUrl().concat("/" + event.getFileName());
            this.fileChannel.postMessage("FILE_MOVE", new LuaFileRefactorChangeInfo(oldFilePath, newFilePath, event.getFile().isDirectory()));
        }
    }

    private void openChannels() {
        this.fileChannel = LuaFileChannel.getInstance(this.project);
    }

    private void closeChannels() {
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }

    private boolean isCurrentProject(String filePath) {
        return LuaNativeUtil.isCurrentProject(this.project, filePath);
    }

    private boolean isFileVisiable(VirtualFile file) {
        return LuaNativeFileUtil.isLuaFile(file.getUrl()) || file.isDirectory();
    }

    private boolean isSingleFileVisiable(VirtualFile file) {
        return LuaNativeFileUtil.isLuaFile(file.getUrl());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/immomo/luanative/sevice/project/file/LuaVirtualFileListenerService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

