/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.document.impl;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.sevice.project.broadcastchannel.LuaFileChannel;
import com.immomo.luanative.sevice.project.document.iLuaDocumentUpdateHandler;
import com.immomo.luanative.util.LuaNativeUtil;
import com.immomo.luanative.util.timer.LuaNativeTimer;
import com.immomo.luanative.util.timer.iLuaTimerTaskHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class LuaDocumentUpdateHandler
implements iLuaDocumentUpdateHandler {
    private Project project;
    private iBroadcastChannel fileChannel;
    private Filter filter = new Filter();

    public LuaDocumentUpdateHandler(Project project) {
        this.project = project;
        this.openChannels();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeChannels();
    }

    @Override
    public void handleDocument(Document doc) {
        VirtualFile vf = FileDocumentManager.getInstance().getFile(doc);
        if (vf != null) {
            System.out.println(">> " + vf.getUrl() + "  changed.");
            if (!vf.getUrl().startsWith("mock://") && LuaNativeUtil.isCurrentProject(this.project, vf.getUrl())) {
                this.filter.update(doc);
            }
        }
    }

    private void postDocument(Document doc) {
        this.fileChannel.postMessage("MODIFY", doc);
    }

    private void openChannels() {
        this.fileChannel = LuaFileChannel.getInstance(this.project);
    }

    private void closeChannels() {
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }

    protected class Filter
    implements iLuaTimerTaskHandler {
        private Document doc;
        private LuaNativeTimer timer = new LuaNativeTimer();

        protected Filter() {
        }

        protected void update(Document doc) {
            if (this.doc != null && !this.doc.equals(doc)) {
                this.doTask();
            }
            this.doc = doc;
            this.resetTimer();
        }

        protected void resetTimer() {
            if (this.timer.isRunning()) {
                this.timer.resetDelay(200L);
            } else {
                this.timer.schedule(this, 200L);
            }
        }

        @Override
        public void doTask() {
            LuaDocumentUpdateHandler.this.postDocument(this.doc);
            this.doc = null;
        }
    }
}

