/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.client;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.channel.ClientChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.channel.DeviceChannel;
import com.immomo.luanative.sevice.AbstractService;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClientDispatcher
extends AbstractService {
    private Project project;
    private iBroadcastChannel clientApplicationChannel = ClientChannel.getInstance();
    private iBroadcastChannel deviceApplicationChannel = DeviceChannel.getInstance();
    private iBroadcastChannel deviceProjectChannel;
    private iBroadcastChannel clientProjectChannel;
    private Set<BaseDevice> deviceSet = new HashSet<BaseDevice>();
    private Map<BaseDevice, iClient> clientMap = new HashMap<BaseDevice, iClient>();

    public ClientDispatcher(Project project) {
        this.project = project;
    }

    @Override
    protected boolean onStart() {
        this.openChannel();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannel();
        return true;
    }

    private void openChannel() {
        this.deviceApplicationChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("AVALIABLE")) {
                    ClientDispatcher.this.deviceProjectChannel.postMessage(event);
                } else if (event.getType().equals("UNAVALIABLE")) {
                    ClientDispatcher.this.deviceProjectChannel.postMessage(event);
                } else if (event.getType().equals("SYNC_AVALIABLE_LIST")) {
                    ClientDispatcher.this.deviceProjectChannel.postMessage(event);
                }
            }
        });
        this.clientApplicationChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("CONNECTED")) {
                    iClient client = (iClient)event.getData();
                    ClientDispatcher.this.clientMap.put(client.getDevice(), client);
                    if (ClientDispatcher.this.deviceSet.contains(client.getDevice())) {
                        ClientDispatcher.this.clientProjectChannel.postMessage("OPEN", client);
                    }
                } else if (event.getType().equals("DISCONNECTED")) {
                    iClient client = (iClient)event.getData();
                    ClientDispatcher.this.clientMap.remove(client.getDevice());
                    ClientDispatcher.this.clientProjectChannel.postMessage("CLOSE", client);
                    ClientDispatcher.this.deviceProjectChannel.postMessage("FAIL_TO_SELECTED", client.getDevice());
                }
            }
        });
        this.deviceProjectChannel = DeviceChannel.getInstance(this.project);
        this.deviceProjectChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("SELECTED")) {
                    ClientDispatcher.this.deviceSet.add(event.getData());
                    if (ClientDispatcher.this.clientMap.containsKey(event.getData())) {
                        ClientDispatcher.this.clientProjectChannel.postMessage("OPEN", ClientDispatcher.this.clientMap.get(event.getData()));
                    } else {
                        ClientDispatcher.this.deviceApplicationChannel.postMessage(event);
                    }
                } else if (event.getType().equals("DESELECTED")) {
                    if (ClientDispatcher.this.deviceSet.contains(event.getData()) && ClientDispatcher.this.clientMap.containsKey(event.getData())) {
                        ClientDispatcher.this.clientProjectChannel.postMessage("CLOSE", ClientDispatcher.this.clientMap.get(event.getData()));
                    }
                    ClientDispatcher.this.deviceSet.remove(event.getData());
                } else if (event.getType().equals("REQUEST_AVALIABLE_LIST")) {
                    ClientDispatcher.this.deviceApplicationChannel.postMessage(event);
                }
            }
        });
        this.clientProjectChannel = ClientChannel.getInstance(this.project);
    }

    private void closeChannel() {
        this.clientApplicationChannel.close();
        this.clientProjectChannel.close();
        this.deviceProjectChannel.close();
    }
}

