/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project.bootstrap;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.dispatcher.BroadcastChannelDispatcherFactory;
import com.immomo.luanative.broadcastchannel.dispatcher.iBroadcastChannelDispatcher;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.project.port.channel.PortChannel;
import com.immomo.luanative.sevice.bootstrap.AbstractServiceBootstrap;
import com.immomo.luanative.sevice.project.ProjectSyncService;
import com.immomo.luanative.sevice.project.client.ClientDispatcher;
import com.immomo.luanative.sevice.project.document.LuaDocumentListenerService;
import com.immomo.luanative.sevice.project.file.LuaVirtualFileListenerService;
import com.immomo.luanative.sevice.project.file.entryfile.LuaEntryFileManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;

public class ProjectServerBootstrap
extends AbstractServiceBootstrap {
    private Project project;
    private iBroadcastChannelDispatcher channelDispatcher;
    private iBroadcastChannel portChannel;
    private boolean isStopped = true;

    public static ProjectServerBootstrap getIntance(Project project) {
        if (project.isDisposed()) {
            return null;
        }
        return (ProjectServerBootstrap)ServiceManager.getService((Project)project, ProjectServerBootstrap.class);
    }

    public ProjectServerBootstrap(Project project) {
        this.project = project;
    }

    @Override
    protected boolean onStart() {
        this.channelDispatcher = BroadcastChannelDispatcherFactory.getInstance(this.project);
        if (this.channelDispatcher != null) {
            this.channelDispatcher.start();
        }
        this.bootstrap(LuaEntryFileManager.class, this.project);
        this.openChannel();
        this.bootstrap(ProjectSyncService.class, this.project);
        this.bootstrap(LuaDocumentListenerService.class, this.project);
        this.bootstrap(ClientDispatcher.class, this.project);
        this.bootstrap(LuaVirtualFileListenerService.class, this.project);
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannel();
        if (this.channelDispatcher != null) {
            this.channelDispatcher.stop();
        }
        return true;
    }

    @Override
    public boolean isRunning() {
        return !this.isStopped;
    }

    private void openChannel() {
        this.portChannel = PortChannel.getInstance(this.project);
        this.portChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("APPLY")) {
                    ProjectServerBootstrap.this.stop();
                    ApplicationManager.getApplication().restart();
                }
            }
        });
    }

    private void closeChannel() {
        if (this.portChannel != null) {
            this.portChannel.close();
        }
    }
}

