/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.project;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.channel.ClientChannel;
import com.immomo.luanative.client.channel.MessageChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.codec.PBCommandFactory;
import com.immomo.luanative.project.file.LuaFileInfo;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.bootstrap.ServiceBootstrapFactory;
import com.immomo.luanative.sevice.bootstrap.iServiceBootstrap;
import com.immomo.luanative.sevice.project.broadcastchannel.LuaFileChannel;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorChangeInfo;
import com.immomo.luanative.sevice.project.file.LuaFileRefactorInfo;
import com.immomo.luanative.sevice.project.file.entryfile.LuaEntryFileManager;
import com.immomo.luanative.util.LuaNativeFileUtil;
import com.immomo.ui.values.HotReloadPreviewFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectSyncService
extends AbstractService {
    private Project project;
    private LuaNativeFileUtil fileUtil;
    private iBroadcastChannel clientChannel;
    private iBroadcastChannel fileChannel;
    private iBroadcastChannel entryFileChannel;
    private Map<iClient, MessageChannel> channelMap = new HashMap<iClient, MessageChannel>();
    private Set<iClient> clientSet = new HashSet<iClient>();

    public ProjectSyncService(Project project) {
        this.project = project;
        this.fileUtil = new LuaNativeFileUtil(project);
    }

    @Override
    protected boolean onStart() {
        this.openChannels();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannels();
        return true;
    }

    private void openChannels() {
        this.clientChannel = ClientChannel.getInstance(this.project);
        this.clientChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("OPEN")) {
                    iClient client = (iClient)event.getData();
                    ProjectSyncService.this.clientSet.add(client);
                    ProjectSyncService.this.syncProjectToClientAndReloadIfNeed(client);
                } else if (event.getType().equals("CLOSE")) {
                    iClient client = (iClient)event.getData();
                    ProjectSyncService.this.clientSet.remove(client);
                }
            }
        });
        this.fileChannel = LuaFileChannel.getInstance(this.project);
        this.fileChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                block11: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block10: {
                                                        if (!event.getType().equals("MODIFY")) break block10;
                                                        HashSet clients = new HashSet(ProjectSyncService.this.clientSet);
                                                        Document document = (Document)event.getData();
                                                        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                                                        for (iClient client : clients) {
                                                            ProjectSyncService.this.syncFileToClientAndReloadIfNeed(client, file.getUrl(), document.getText());
                                                        }
                                                        break block11;
                                                    }
                                                    if (!event.getType().equals("OPEN_AUTO_SYNC")) break block12;
                                                    for (iClient client : ProjectSyncService.this.clientSet) {
                                                        ProjectSyncService.this.syncProjectToClientAndReloadIfNeed(client);
                                                    }
                                                    break block11;
                                                }
                                                if (!event.getType().equals("FORCE_SYNC")) break block13;
                                                for (iClient client : ProjectSyncService.this.clientSet) {
                                                    ProjectSyncService.this.syncProjectToClientAndReload(client);
                                                }
                                                break block11;
                                            }
                                            if (!event.getType().equals("FILE_RENAME")) break block14;
                                            LuaFileRefactorChangeInfo info = (LuaFileRefactorChangeInfo)event.getData();
                                            for (iClient client : ProjectSyncService.this.clientSet) {
                                                ProjectSyncService.this.syncClientToFileRenameAndReload(client, info);
                                            }
                                            break block11;
                                        }
                                        if (!event.getType().equals("FILE_DELETE")) break block15;
                                        LuaFileRefactorInfo info = (LuaFileRefactorInfo)event.getData();
                                        for (iClient client : ProjectSyncService.this.clientSet) {
                                            ProjectSyncService.this.syncClientToFileDeletedAndReload(client, info);
                                        }
                                        break block11;
                                    }
                                    if (!event.getType().equals("FILE_MOVE")) break block16;
                                    LuaFileRefactorChangeInfo info = (LuaFileRefactorChangeInfo)event.getData();
                                    for (iClient client : ProjectSyncService.this.clientSet) {
                                        ProjectSyncService.this.syncClientToFileMoveAndReload(client, info);
                                    }
                                    break block11;
                                }
                                if (!event.getType().equals("FILE_CREATE")) break block17;
                                LuaFileRefactorInfo info = (LuaFileRefactorInfo)event.getData();
                                for (iClient client : ProjectSyncService.this.clientSet) {
                                    ProjectSyncService.this.syncClientToFileCreatedAndReload(client, info);
                                }
                                break block11;
                            }
                            if (!event.getType().equals("LUA_CODE_COVERAGE")) break block18;
                            boolean isOpen = (Boolean)event.getData();
                            for (iClient client : ProjectSyncService.this.clientSet) {
                                ProjectSyncService.this.syncClientCodeCoverageCommand(client, isOpen);
                            }
                            break block11;
                        }
                        if (!event.getType().equals("CLEAR_PREVIOUS_COVERAGE_RESULT")) break block19;
                        boolean shouldClear = (Boolean)event.getData();
                        for (iClient client : ProjectSyncService.this.clientSet) {
                            ProjectSyncService.this.syncClientClearPreviousCoverageCommand(client, shouldClear);
                        }
                        break block11;
                    }
                    if (!event.getType().equals("GENE_COVERAGE_REPORT_ACTION")) break block11;
                    for (iClient client : ProjectSyncService.this.clientSet) {
                        ProjectSyncService.this.generateCodeCoverageReport(client);
                    }
                }
            }
        });
        this.entryFileChannel = LuaFileChannel.getEntryFileInstance(this.project);
        this.entryFileChannel.onMessage(event -> {
            if (event.getType().equals("SELECTED")) {
                HashSet<iClient> clients = new HashSet<iClient>(this.clientSet);
                for (iClient client : clients) {
                    this.syncEntryFileToClientAndReloadIfNeed(client);
                }
            }
        });
    }

    private void closeChannels() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
        }
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
        if (this.entryFileChannel != null) {
            this.entryFileChannel.close();
        }
    }

    private void syncProjectToClientAndReloadIfNeed(iClient client) {
        if (!LuaNativeProjectSetting.isAutoSyncOpen()) {
            return;
        }
        this.syncProjectToClientAndReload(client);
    }

    private void syncProjectToClientAndReload(iClient client) {
        this.syncAllFilesToClient(client);
        this.syncEntryFileToClientAndReload(client);
    }

    private void syncAllFilesToClient(iClient client) {
        if (this.project.isDisposed()) {
            return;
        }
        if (this.fileUtil.getSrcFile() == null) {
            return;
        }
        if (this.fileUtil.getSrcFile().isDirectory()) {
            this.syncDirectoryToClient(client, this.fileUtil.getSrcFile());
        }
    }

    private void syncDirectoryToClient(iClient client, VirtualFile file) {
        if (!file.isDirectory()) {
            return;
        }
        for (VirtualFile aFile : file.getChildren()) {
            if (aFile.isDirectory()) {
                this.syncDirectoryToClient(client, aFile);
                continue;
            }
            try {
                System.out.println(">>> \u5f00\u59cb\u540c\u6b65\u6587\u4ef6" + aFile.getUrl());
                Document doc = FileDocumentManager.getInstance().getDocument(aFile);
                if (doc != null) {
                    this.syncFileToClient(client, aFile.getUrl(), doc.getText());
                    continue;
                }
                this.syncFileToClient(client, aFile.getUrl(), VfsUtilCore.loadText((VirtualFile)aFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void syncFileToClientAndReloadIfNeed(iClient client, String filePath, String content) {
        if (!LuaNativeFileUtil.isLuaFile(filePath)) {
            return;
        }
        if (!LuaNativeProjectSetting.isAutoSyncOpen()) {
            return;
        }
        this.syncFileToClientAndReload(client, filePath, content);
    }

    private void syncFileToClientAndReload(iClient client, String filePath, String content) {
        if (!LuaNativeFileUtil.isLuaFile(filePath)) {
            return;
        }
        this.syncFileToClient(client, filePath, content);
        this.syncEntryFileToClientAndReload(client);
    }

    private void syncFileToClient(iClient client, String filePath, String content) {
        if (!LuaNativeFileUtil.isLuaFile(filePath)) {
            return;
        }
        String relativeEntryFilePath = this.getSrcRelativePath(filePath);
        filePath = HotReloadPreviewFileUtil.getPreviewFilePath(filePath);
        relativeEntryFilePath = HotReloadPreviewFileUtil.getPreviewRelativePath(relativeEntryFilePath);
        Object cmd = PBCommandFactory.getUpdateCommand(filePath, relativeEntryFilePath, content);
        System.out.println(">>> \u53d1\u9001\u6d88\u606f " + client);
        this.getClientSendChannel(client).post(cmd);
    }

    private void syncEntryFileToClientAndReloadIfNeed(iClient client) {
        if (!LuaNativeProjectSetting.isAutoSyncOpen()) {
            return;
        }
        this.syncEntryFileToClient(client);
        this.syncClientToReload(client);
    }

    private void syncEntryFileToClientAndReload(iClient client) {
        this.syncEntryFileToClient(client);
        this.syncClientToReload(client);
    }

    private void syncEntryFileToClient(iClient client) {
        LuaFileInfo entryFileInfo = this.getEntryFileInfo();
        if (entryFileInfo != null) {
            String filePath = entryFileInfo.getFilePath();
            filePath = HotReloadPreviewFileUtil.getPreviewFilePath(filePath);
            String relativeEntryFilePath = HotReloadPreviewFileUtil.getPreviewRelativePath(entryFileInfo.getRelativeFilePath());
            Object cmd = PBCommandFactory.getEntryFileCommand(filePath, relativeEntryFilePath, entryFileInfo.getParams());
            this.getClientSendChannel(client).post(cmd);
        }
    }

    private void syncClientToReload(iClient client) {
        Object reload_cmd = PBCommandFactory.getReloadCommand();
        this.getClientSendChannel(client).post(reload_cmd);
    }

    private void syncClientToFileRenameAndReload(iClient client, LuaFileRefactorChangeInfo info) {
        this.syncClientToFileRename(client, info);
        this.syncClientToReload(client);
    }

    private void syncClientToFileRename(iClient client, LuaFileRefactorChangeInfo info) {
        if (this.project.isDisposed()) {
            return;
        }
        String oldRelativePath = this.getSrcRelativePath(info.getOldFilePath());
        String newRelativePath = this.getSrcRelativePath(info.getNewFilePath());
        oldRelativePath = HotReloadPreviewFileUtil.getPreviewRelativePath(oldRelativePath);
        newRelativePath = HotReloadPreviewFileUtil.getPreviewRelativePath(newRelativePath);
        String newFile = HotReloadPreviewFileUtil.getPreviewFilePath(info.getNewFilePath());
        String oldFile = HotReloadPreviewFileUtil.getPreviewFilePath(info.getOldFilePath());
        Object reload_cmd = PBCommandFactory.getRenameCommand(oldFile, oldRelativePath, newFile, newRelativePath);
        this.getClientSendChannel(client).post(reload_cmd);
    }

    private void syncClientToFileCreatedAndReload(iClient client, LuaFileRefactorInfo info) {
        this.syncClientToFileCreated(client, info);
        this.syncClientToReload(client);
    }

    private void syncClientToFileCreated(iClient client, LuaFileRefactorInfo info) {
        if (this.project.isDisposed()) {
            return;
        }
        String relativeFilePath = this.getSrcRelativePath(info.getFilePath());
        String filePath = HotReloadPreviewFileUtil.getPreviewFilePath(info.getFilePath());
        relativeFilePath = HotReloadPreviewFileUtil.getPreviewRelativePath(relativeFilePath);
        Object reload_cmd = PBCommandFactory.getCreateCommand(filePath, relativeFilePath);
        this.getClientSendChannel(client).post(reload_cmd);
    }

    private void syncClientToFileDeletedAndReload(iClient client, LuaFileRefactorInfo info) {
        this.syncClientToFileDeleted(client, info);
        this.syncClientToReload(client);
    }

    private void syncClientToFileDeleted(iClient client, LuaFileRefactorInfo info) {
        if (this.project.isDisposed()) {
            return;
        }
        String relativeFilePath = this.getSrcRelativePath(info.getFilePath());
        String filePath = HotReloadPreviewFileUtil.getPreviewFilePath(info.getFilePath());
        relativeFilePath = HotReloadPreviewFileUtil.getPreviewRelativePath(relativeFilePath);
        Object reload_cmd = PBCommandFactory.getRemoveCommand(filePath, relativeFilePath);
        this.getClientSendChannel(client).post(reload_cmd);
    }

    private void syncClientToFileMoveAndReload(iClient client, LuaFileRefactorChangeInfo info) {
        this.syncClientToFileMove(client, info);
        this.syncClientToReload(client);
    }

    private void syncClientToFileMove(iClient client, LuaFileRefactorChangeInfo info) {
        if (this.project.isDisposed()) {
            return;
        }
        String oldRelativePath = this.getSrcRelativePath(info.getOldFilePath());
        String newRelativePath = this.getSrcRelativePath(info.getNewFilePath());
        oldRelativePath = HotReloadPreviewFileUtil.getPreviewRelativePath(oldRelativePath);
        newRelativePath = HotReloadPreviewFileUtil.getPreviewRelativePath(newRelativePath);
        String newFile = HotReloadPreviewFileUtil.getPreviewFilePath(info.getNewFilePath());
        String oldFile = HotReloadPreviewFileUtil.getPreviewFilePath(info.getOldFilePath());
        Object cmd = PBCommandFactory.getMoveCommand(oldFile, oldRelativePath, newFile, newRelativePath);
        this.getClientSendChannel(client).post(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageChannel getClientSendChannel(iClient client) {
        MessageChannel channel = this.channelMap.get(client);
        if (channel == null) {
            ProjectSyncService projectSyncService = this;
            synchronized (projectSyncService) {
                channel = this.channelMap.get(client);
                if (channel == null) {
                    channel = (MessageChannel)MessageChannel.getSendInstance(client);
                    this.channelMap.put(client, channel);
                }
            }
        }
        return channel;
    }

    private String getSrcRelativePath(String filePath) {
        return this.fileUtil.getSrcRelativePath(filePath);
    }

    private LuaFileInfo getEntryFileInfo() {
        LuaEntryFileManager fileManager;
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(this.project);
        if (bootstrap != null && (fileManager = (LuaEntryFileManager)bootstrap.bootstrap(LuaEntryFileManager.class, this.project)) != null) {
            return fileManager.getSelectedEntryFileInfo();
        }
        return null;
    }

    private void syncClientCodeCoverageCommand(iClient client, final boolean isOpen) {
        if (this.project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Document doc = ProjectSyncService.this.getEntryFileDocument();
                if (doc != null) {
                    String toInsertText = "local runner = require('MLNCodeCoverage.luacov')\nfunction gencoveragereport() runner.shutdown() end\n";
                    String oldContent = doc.getText();
                    int index = oldContent.indexOf(toInsertText);
                    if (isOpen && index == -1) {
                        String newContent = "" + toInsertText + oldContent;
                        doc.setText((CharSequence)newContent);
                    } else if (!isOpen && index != -1) {
                        String newContent = oldContent.substring(0, index) + oldContent.substring(index + toInsertText.length());
                        doc.setText((CharSequence)newContent);
                    }
                }
            }
        });
    }

    private void syncClientClearPreviousCoverageCommand(iClient client, final boolean shouldClear) {
        if (this.project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Document doc = ProjectSyncService.this.getEntryFileDocument();
                if (doc != null) {
                    String toInsertText = "MLNCodeCovClearPreviousResult{'luacov.stats.out', 'luacov.report.out', 'luacov.summary.out', 'cobertura.report.out'}\n";
                    String oldContent = doc.getText();
                    int index = oldContent.indexOf(toInsertText);
                    if (shouldClear && index == -1) {
                        String newContent = "" + toInsertText + oldContent;
                        doc.setText((CharSequence)newContent);
                    } else if (!shouldClear && index != -1) {
                        String newContent = oldContent.substring(0, index) + oldContent.substring(index + toInsertText.length());
                        doc.setText((CharSequence)newContent);
                    }
                }
            }
        });
    }

    private void generateCodeCoverageReport(iClient client) {
        if (this.project.isDisposed()) {
            return;
        }
        Object cmd = PBCommandFactory.getCoverageVisualCommand();
        this.getClientSendChannel(client).post(cmd);
    }

    private Document getEntryFileDocument() {
        LuaFileInfo entryFileInfo = this.getEntryFileInfo();
        if (entryFileInfo == null) {
            return null;
        }
        String filePath = entryFileInfo.getFilePath();
        VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(filePath);
        Document doc = FileDocumentManager.getInstance().getDocument(vf);
        return doc;
    }
}

