/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.device.finder.impl;

import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.DeviceCachedFactory;
import com.immomo.luanative.sevice.application.device.finder.AbstractDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinderListener;
import com.mogaleaf.usbmuxd.api.exception.UsbMuxdException;
import com.mogaleaf.usbmuxd.api.model.Device;
import com.mogaleaf.usbmuxd.protocol.DeviceListener;
import com.mogaleaf.usbmuxd.protocol.PlistMessageService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public class iOSUsbDeviceFinder
extends AbstractDeviceFinder {
    private Socket connectionListeningSocket;
    protected DeviceListener deviceListener = new DeviceListener();

    public iOSUsbDeviceFinder(iDeviceFinderListener listener) {
        super(listener);
    }

    @Override
    public void run() {
        try {
            this.startListening();
        }
        catch (UsbMuxdException e) {
            e.printStackTrace();
            this.notifyError(e.getMessage());
        }
    }

    private void startListening() throws UsbMuxdException {
        try {
            this.connectionListeningSocket = this.getSocketImpl();
            this.connectionListeningSocket.connect(this.getAddress());
            byte[] connectByteMessage = PlistMessageService.buildListenConnectionMsg();
            InputStream inputStream = this.connectionListeningSocket.getInputStream();
            this.deviceListener.start(inputStream);
            this.deviceListener.register(m -> {
                switch (m.type) {
                    case Add: {
                        System.out.println("+++ ios" + m.device);
                        BaseDevice device = DeviceCachedFactory.getInstance(m.device, (int)BaseDevice.USB_CONNECTION);
                        this.availableDevices.add(device);
                        this.notifyOnDeviceAviliable(device);
                        break;
                    }
                    case Remove: {
                        System.out.println("--- ios" + m.device);
                        BaseDevice device = this.findDevice(m.device);
                        if (device == null) break;
                        this.availableDevices.remove(device);
                        this.notifyOnDeviceUnaviliable(device);
                        break;
                    }
                }
            });
            this.connectionListeningSocket.getOutputStream().write(connectByteMessage);
            this.deviceListener.run();
        }
        catch (Exception e) {
            throw new UsbMuxdException(e);
        }
    }

    private BaseDevice findDevice(Device device) {
        for (BaseDevice device_t : this.availableDevices) {
            if (device_t.getDeviceId() != device.deviceId) continue;
            return device_t;
        }
        return null;
    }

    private SocketAddress getAddress() throws IOException {
        return new AFUNIXSocketAddress(new File("/var/run/usbmuxd"));
    }

    protected Socket getSocketImpl() throws IOException {
        return AFUNIXSocket.newInstance();
    }
}

