/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.device.finder.impl;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.channel.ClientChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.codec.decode.DecoderFactory;
import com.immomo.luanative.codec.decode.iDecoder;
import com.immomo.luanative.codec.decode.iDecodingListener;
import com.immomo.luanative.codec.protobuf.PBDeviceCommand;
import com.immomo.luanative.conn.LuaNativeTransportUtil;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.DeviceCachedFactory;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.sevice.application.device.finder.AbstractDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinderListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;

public class NetDeivceFinder
extends AbstractDeviceFinder {
    private ServerSocketChannel server;
    private List<BaseDevice> failDevices = new ArrayList<BaseDevice>();
    private iBroadcastChannel clientChannel;

    public NetDeivceFinder(iDeviceFinderListener listener) {
        super(listener);
    }

    @Override
    protected boolean onStop() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
            this.clientChannel = null;
        }
        try {
            this.closeServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.onStop();
    }

    @Override
    public void run() {
        this.openChannel();
        try {
            this.loadServer();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.notifyError(e.getMessage());
        }
        while (this.isRunning() && this.server != null && this.server.isOpen()) {
            try {
                this.handleFailDeivces();
                this.accpet();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.notifyError(e.getMessage());
            }
        }
    }

    private void openChannel() {
        if (this.clientChannel != null) {
            return;
        }
        this.clientChannel = ClientChannel.getInstance();
        this.clientChannel.onMessage(new iBroadcastChannelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(iMessageEvent event) {
                iClient client;
                if (event.getType().equals("DISCONNECTED") && (client = (iClient)event.getData()).getClientType().equals("CLIENT_NET")) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        NetDeivceFinder.this.failDevices.add(client.getDevice());
                        NetDeivceFinder.this.availableDevices.remove(client.getDevice());
                    }
                    NetDeivceFinder.this.handleFailDeivces();
                }
            }
        });
    }

    private void loadServer() throws IOException {
        if (this.server == null) {
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(true);
            this.server.bind(new InetSocketAddress(LuaNativeProjectSetting.getNetPort()));
        }
    }

    private void closeServer() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailDeivces() {
        ArrayList<BaseDevice> failDevicesTmp = null;
        if (this.failDevices.size() > 0) {
            NetDeivceFinder netDeivceFinder = this;
            synchronized (netDeivceFinder) {
                if (this.failDevices.size() > 0) {
                    failDevicesTmp = new ArrayList<BaseDevice>(this.failDevices);
                }
            }
        }
        if (failDevicesTmp != null) {
            for (BaseDevice device : failDevicesTmp) {
                NetDeivceFinder netDeivceFinder = this;
                synchronized (netDeivceFinder) {
                    this.failDevices.remove(device);
                }
                this.notifyOnDeviceUnaviliable(device);
            }
        }
    }

    private void accpet() throws IOException {
        SocketChannel channel = null;
        channel = this.server.accept();
        if (channel != null) {
            this.getDeviceInfo(channel);
        }
    }

    private void getDeviceInfo(SocketChannel channel) throws IOException {
        ByteArrayOutputStream bytesOutputStream = new ByteArrayOutputStream();
        int readSize = 0;
        ByteBuffer bf = ByteBuffer.allocate(0x100000);
        try {
            readSize = channel.read(bf);
            if (readSize < 0) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.notifyError(e.getMessage());
        }
        if (readSize > 0) {
            bytesOutputStream.write(bf.array(), 0, readSize);
            bf.clear();
            iDecoder decoder = this.createDecoder(channel);
            decoder.push(bytesOutputStream.toByteArray());
        }
    }

    private iDecoder createDecoder(final SocketChannel channel) {
        return DecoderFactory.getInstance(new iDecodingListener(){

            @Override
            public void onDecoding(Object obj) {
                if (obj instanceof PBDeviceCommand.pbdevicecommand) {
                    PBDeviceCommand.pbdevicecommand cmd = (PBDeviceCommand.pbdevicecommand)obj;
                    BaseDevice device = DeviceCachedFactory.getInstance(cmd, BaseDevice.NET_CONNECTION, channel);
                    if (!NetDeivceFinder.this.availableDevices.contains(device)) {
                        NetDeivceFinder.this.availableDevices.add(device);
                        LuaNativeTransportUtil.update(device, channel);
                        NetDeivceFinder.this.notifyOnDeviceAviliable(device);
                    }
                }
            }
        });
    }
}

