/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.device.finder.impl;

import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.DeviceCachedFactory;
import com.immomo.luanative.sevice.application.device.finder.AbstractDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinderListener;
import com.immomo.luanative.util.adb.AdbUtil;
import com.immomo.luanative.util.adb.iAdbListener;
import com.intellij.util.EnvironmentUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AndroidUsbDeviceFinder
extends AbstractDeviceFinder {
    public AndroidUsbDeviceFinder(iDeviceFinderListener listener) {
        super(listener);
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            List<BaseDevice> devices = null;
            try {
                devices = this.findDevices();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.notifyError(e.getMessage());
            }
            this.checkDiffrent(devices);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.notifyError(e.getMessage() + EnvironmentUtil.getEnvironment());
            }
        }
    }

    private List<BaseDevice> findDevices() throws IOException {
        final ArrayList<BaseDevice> tmpDevices = new ArrayList<BaseDevice>();
        AdbUtil.findDeives(new iAdbListener(){

            @Override
            public void onListDevice(String info) {
                BaseDevice device;
                String[] substr = info.split("\\s+");
                if (substr.length > 2 && (device = DeviceCachedFactory.getInstance("Android", substr, (int)BaseDevice.USB_CONNECTION)) != null) {
                    tmpDevices.add(device);
                }
            }
        });
        return tmpDevices;
    }

    private void checkDiffrent(List<BaseDevice> newDevices) {
        if (newDevices == null || newDevices.size() < 0) {
            return;
        }
        if (this.availableDevices.size() <= 0) {
            for (BaseDevice device : newDevices) {
                this.notifyOnDeviceAviliable(device);
            }
        } else {
            ArrayList disconnectedDevices = new ArrayList(this.availableDevices);
            disconnectedDevices.removeAll(newDevices);
            if (disconnectedDevices.size() > 0) {
                for (BaseDevice device : disconnectedDevices) {
                    this.notifyOnDeviceUnaviliable(device);
                }
            }
            ArrayList<BaseDevice> devicesTmp = new ArrayList<BaseDevice>(newDevices);
            devicesTmp.removeAll(this.availableDevices);
            for (BaseDevice device : devicesTmp) {
                this.notifyOnDeviceAviliable(device);
            }
        }
        this.availableDevices = newDevices;
    }
}

