/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.device.finder;

import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinderListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractDeviceFinder
extends AbstractService
implements iDeviceFinder,
Runnable {
    private ExecutorService cachedThreadPool = Executors.newSingleThreadExecutor();
    protected iDeviceFinderListener listener;
    protected List<BaseDevice> availableDevices = new ArrayList<BaseDevice>();

    public AbstractDeviceFinder(iDeviceFinderListener listener) {
        this.listener = listener;
    }

    @Override
    protected boolean onStart() {
        this.cachedThreadPool.execute(this);
        this.notifyOnStart();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.notifyOnStop();
        return true;
    }

    @Override
    public List<BaseDevice> getAvailableDevices() {
        return this.availableDevices;
    }

    protected void notifyOnStart() {
        if (this.listener != null) {
            this.listener.onStart(this);
        }
    }

    protected void notifyOnStop() {
        if (this.listener != null) {
            this.listener.onStop(this);
        }
    }

    protected void notifyError(String errmsg) {
        if (this.listener != null) {
            this.listener.onError(this, errmsg);
        }
    }

    protected void notifyOnDeviceAviliable(BaseDevice device) {
        if (this.listener != null) {
            this.listener.onDeviceAviliable(this, device);
        }
    }

    protected void notifyOnDeviceUnaviliable(BaseDevice device) {
        if (this.listener != null) {
            this.listener.onDeviceUnaviliable(this, device);
        }
    }
}

