/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.device;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.channel.DeviceChannel;
import com.immomo.luanative.sevice.AbstractService;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.iDeviceFinderListener;
import com.immomo.luanative.sevice.application.device.finder.impl.AndroidUsbDeviceFinder;
import com.immomo.luanative.sevice.application.device.finder.impl.NetDeivceFinder;
import com.immomo.luanative.sevice.application.device.finder.impl.iOSUsbDeviceFinder;
import com.immomo.luanative.sevice.bootstrap.ServiceBootstrapFactory;
import com.immomo.luanative.sevice.bootstrap.iServiceBootstrap;

public class DeviceFinderService
extends AbstractService
implements iDeviceFinderListener {
    private iDeviceFinder netDeviceFinder;
    private iDeviceFinder androidUsbinder;
    private iDeviceFinder iOSUsbinder;
    private iBroadcastChannel deviceChannel;

    @Override
    protected boolean onStart() {
        this.netDeviceFinder = this.bootstrap(NetDeivceFinder.class);
        this.iOSUsbinder = this.bootstrap(iOSUsbDeviceFinder.class);
        this.androidUsbinder = this.bootstrap(AndroidUsbDeviceFinder.class);
        this.openChannels();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannels();
        if (this.netDeviceFinder != null) {
            this.netDeviceFinder.stop();
        }
        if (this.iOSUsbinder != null) {
            this.iOSUsbinder.stop();
        }
        if (this.androidUsbinder != null) {
            this.androidUsbinder.stop();
        }
        return true;
    }

    @Override
    public void onDeviceAviliable(iDeviceFinder finder, BaseDevice device) {
        this.deviceChannel.postMessage("AVALIABLE", device);
    }

    @Override
    public void onDeviceUnaviliable(iDeviceFinder finder, BaseDevice device) {
        this.deviceChannel.postMessage("UNAVALIABLE", device);
    }

    @Override
    public void onStart(iDeviceFinder finder) {
        System.out.println("iDeviceFinder" + finder + "\u5df2\u542f\u52a8");
    }

    @Override
    public void onError(iDeviceFinder finder, String errmsg) {
        finder.stop();
        System.out.println("iDeviceFinder" + finder + "\u51fa\u73b0\u9519\u8bef\uff0c" + errmsg);
    }

    @Override
    public void onStop(iDeviceFinder finder) {
        System.out.println("iDeviceFinder" + finder + "\u5df2\u5173\u95ed");
    }

    private void openChannels() {
        this.deviceChannel = DeviceChannel.getInstance();
        this.deviceChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                if (event.getType().equals("REQUEST_AVALIABLE_LIST")) {
                    if (DeviceFinderService.this.iOSUsbinder != null) {
                        DeviceFinderService.this.deviceChannel.postMessage("SYNC_AVALIABLE_LIST", DeviceFinderService.this.iOSUsbinder.getAvailableDevices());
                    }
                    if (DeviceFinderService.this.androidUsbinder != null) {
                        DeviceFinderService.this.deviceChannel.postMessage("SYNC_AVALIABLE_LIST", DeviceFinderService.this.androidUsbinder.getAvailableDevices());
                    }
                    if (DeviceFinderService.this.netDeviceFinder != null) {
                        DeviceFinderService.this.deviceChannel.postMessage("SYNC_AVALIABLE_LIST", DeviceFinderService.this.netDeviceFinder.getAvailableDevices());
                    }
                }
            }
        });
    }

    private void closeChannels() {
        if (this.deviceChannel != null) {
            this.deviceChannel.close();
        }
    }

    private iDeviceFinder bootstrap(Class clazz) {
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getApplicationInstance();
        if (bootstrap != null) {
            return (iDeviceFinder)bootstrap.bootstrap(clazz, this);
        }
        return null;
    }
}

