/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.sevice.application.client;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.ClientFactory;
import com.immomo.luanative.client.channel.ClientChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.client.iClientListener;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.channel.DeviceChannel;
import com.immomo.luanative.sevice.AbstractService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import java.util.HashMap;
import java.util.Map;

public class ClientManager
extends AbstractService
implements iClientListener {
    private Map<BaseDevice, iClient> clientCachedMap = new HashMap<BaseDevice, iClient>();
    private iBroadcastChannel clientChannel = ClientChannel.getInstance();
    private iBroadcastChannel deviceChannel = DeviceChannel.getInstance();

    @Override
    protected boolean onStart() {
        this.openChannels();
        return true;
    }

    @Override
    protected boolean onStop() {
        this.closeChannels();
        return true;
    }

    @Override
    public void onConnected(iClient client) {
        this.clientChannel.postMessage("CONNECTED", client);
    }

    @Override
    public void onError(iClient client, final String errmsg) {
        client.disconnect();
        if (errmsg != null) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Messages.showInfoMessage((String)errmsg, (String)"\u8fde\u63a5\u65ad\u5f00");
                }
            });
        }
    }

    @Override
    public <T> void onMessage(iClient client, T message2) {
    }

    @Override
    public void disconnect(iClient client) {
        this.clientChannel.postMessage("DISCONNECTED", client);
    }

    private void openChannels() {
        this.deviceChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                BaseDevice device;
                if (event.getType().equals("SELECTED") && (device = (BaseDevice)event.getData()) != null) {
                    ClientManager.this.startClient(device);
                }
            }
        });
    }

    private void closeChannels() {
        if (this.deviceChannel != null) {
            this.deviceChannel.close();
        }
    }

    private void startClient(BaseDevice device) {
        iClient client = this.getClient(device);
        if (client != null && !client.isConnected()) {
            client.connect();
        } else {
            this.clientChannel.postMessage("CONNECTED", client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private iClient getClient(BaseDevice device) {
        iClient client = this.clientCachedMap.get(device);
        if (client == null) {
            ClientManager clientManager = this;
            synchronized (clientManager) {
                if (client == null) {
                    client = ClientFactory.getInstance(device, this);
                    this.clientCachedMap.put(device, client);
                }
            }
        }
        return client;
    }
}

