/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.toolwindow.views.impl.BasePacketView;
import com.immomo.luanative.sevice.project.presenter.impl.FepPresenter;
import com.immomo.luanative.utils.fep.FepConfigs;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.swingx.HorizontalLayout;

public class FepView
extends BasePacketView {
    private JButton packageButton;
    private JTextField bid;
    private JTextField version;
    private JTextField gitUrl;
    private JTextField commitMsg;
    private JTextField momoid;
    private JPasswordField password;
    private JTextField fileName;
    private FepPresenter presenter;

    public FepView(FepPresenter presenter) {
        this.presenter = presenter;
    }

    public void init(JComponent root) {
        JSeparator separator = new JSeparator();
        root.add(separator);
        JLabel title = new JLabel("FEP\u9009\u9879:");
        title.setFont(FepView.newFont(12));
        root.add(title);
        this.compileComponent(root);
        JPanel panel = this.newLinearPanel(root);
        this.bid = this.create(panel, "bid", 50, 0);
        this.version = this.create(panel, "version", 0, 0);
        this.version.setText("1.x");
        panel = this.newLinearPanel(root);
        this.gitUrl = this.create(panel, "git url", 50, 300);
        panel = this.newLinearPanel(root);
        this.commitMsg = this.create(panel, "commit", 50, 300);
        this.commitMsg.setText("commit_message");
        panel = this.newLinearPanel(root);
        this.momoid = this.create(panel, "Momo Id", 50, 0);
        JLabel l = new JLabel("password:");
        l.setFont(FepView.newFont(10));
        panel.add(l);
        this.password = new JPasswordField();
        this.password.setPreferredSize(new Dimension(100, FepView.getOldHeight(this.password)));
        panel.add(this.password);
        panel = this.newLinearPanel(root);
        this.fileName = this.create(panel, "file name", 50, 300);
        panel = this.newLinearPanel(root);
        this.packageButton = new JButton("\u5f00\u59cb");
        this.packageButton.setPreferredSize(new Dimension(400, FepView.getOldHeight(this.packageButton)));
        panel.add(this.packageButton);
        this.packageButton.addActionListener(e -> {
            boolean start;
            this.packageButton.setEnabled(false);
            int[] types = this.checkTypes();
            if (types == null && this.compileCheck.isSelected()) {
                this.packageButton.setEnabled(true);
                return;
            }
            if (this.compileCheck.isSelected() && types.length > 1) {
                FepView.showError("\u5f53\u524dFep\u4efb\u52a1\u53ea\u652f\u6301\u53d1\u5e03\u4e00\u79cd\u7f16\u8bd1\u7248\u672c");
                this.packageButton.setEnabled(true);
                return;
            }
            FepConfigs configs = this.makeConfig();
            if (configs == null) {
                this.packageButton.setEnabled(true);
                return;
            }
            String giturl = this.gitUrl.getText();
            if (giturl == null || giturl.isEmpty()) {
                this.packageButton.setEnabled(true);
                FepView.showError("git url\u5fc5\u987b\u586b\u5199");
                return;
            }
            String fileName = this.fileName.getText();
            if (fileName == null || fileName.isEmpty()) {
                fileName = null;
            }
            if (start = this.presenter.doTask(fileName, giturl, configs, this.compileCheck.isSelected(), types == null ? 0 : types[0])) {
                this.packageButton.setText("\u6253\u5305\u4e2d...");
            } else {
                this.packageButton.setEnabled(true);
            }
        });
    }

    private FepConfigs makeConfig() {
        int bid;
        try {
            bid = Integer.parseInt(this.bid.getText());
        }
        catch (Throwable t) {
            FepView.showError("bid\u5fc5\u987b\u4e3a\u6570\u5b57");
            return null;
        }
        String version = this.version.getText();
        if (version == null || version.isEmpty()) {
            FepView.showError("version\u5fc5\u987b\u586b\u5199\uff0c\u6bd4\u5982: 1.x");
            return null;
        }
        String commitMsg = this.commitMsg.getText();
        if (commitMsg == null || commitMsg.isEmpty()) {
            FepView.showError("commit message\u5fc5\u987b\u586b\u5199");
            return null;
        }
        String momoid = this.momoid.getText();
        if (momoid == null || momoid.isEmpty()) {
            FepView.showError("momo\u53f7\u5fc5\u987b\u586b\u5199");
            return null;
        }
        char[] s = this.password.getPassword();
        if (s == null || s.length == 0) {
            FepView.showError("momo\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
            return null;
        }
        String psw = new String(s);
        FepConfigs configs = new FepConfigs(bid);
        configs.versionX = version;
        configs.commitMsg = commitMsg;
        configs.mmid = momoid;
        configs.psw = psw;
        return configs;
    }

    private JPanel newLinearPanel(JComponent root) {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(200, 30));
        panel.setLayout((LayoutManager)new HorizontalLayout(5));
        root.add(panel);
        return panel;
    }

    private JTextField create(JComponent parent, String label2, int lw, int w) {
        JLabel l = new JLabel(label2 + ":");
        l.setFont(FepView.newFont(10));
        if (lw > 0) {
            l.setPreferredSize(new Dimension(lw, FepView.getOldHeight(l)));
        }
        JTextField f = new JTextField();
        if (w == 0) {
            f.setPreferredSize(new Dimension(100, FepView.getOldHeight(f)));
        } else {
            f.setPreferredSize(new Dimension(w, FepView.getOldHeight(f)));
        }
        parent.add(l);
        parent.add(f);
        return f;
    }

    @Override
    public void onFinishPacket() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.packageButton.setEnabled(true);
            this.packageButton.setText("\u5f00\u59cb");
        });
    }

    public void onStateChange(String state2) {
        ApplicationManager.getApplication().invokeLater(() -> this.packageButton.setText(state2));
    }
}

