/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.file.LuaFileInfo;
import com.immomo.luanative.project.toolwindow.ComboBox.ComboBoxFactory;
import com.immomo.luanative.project.toolwindow.ComboBox.iLuaNativeComboBoxItem;
import com.immomo.luanative.project.toolwindow.ComboBox.impl.LuaNativeComboBoxRender;
import com.immomo.luanative.project.toolwindow.views.iEntryFileSettingListener;
import com.immomo.luanative.project.toolwindow.views.iEntryFileSettingView;
import com.immomo.luanative.util.LuaNativeIconLoader;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EntryFileSettingsView
implements ItemListener,
iEntryFileSettingView {
    private JPanel rootPanel;
    private JTextField paramsTextField;
    private JToggleButton openCovButton;
    private JToggleButton clearCovButton;
    private ComboBox entryFilesBox;
    private iEntryFileSettingListener listener;
    private static iLuaNativeComboBoxItem defaultFileItem = ComboBoxFactory.getInstance(new LuaFileInfo(null, "- \u8bf7\u9009\u62e9 -", null), false);

    public EntryFileSettingsView(iEntryFileSettingListener listener) {
        this.listener = listener;
    }

    public JComponent init() {
        int left = 8;
        int top = 15;
        int tabH = 15;
        int tabV = 12;
        int lineHeight = 30;
        int first_width = 120;
        int second_width = 220;
        int btn_width = 100;
        int first_x = left + tabH;
        int second_x = left + tabH + first_width;
        int maxY = top;
        int maxX = second_x + second_width;
        Font subFont = new Font("Default", 0, 12);
        Font infoFont = new Font("Default", 0, 10);
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(null);
        this.rootPanel.setMinimumSize(new Dimension(380, 180));
        JLabel entryFileLabel = new JLabel("Entry File");
        entryFileLabel.setBounds(first_x, maxY, first_width, lineHeight);
        entryFileLabel.setFont(subFont);
        this.rootPanel.add(entryFileLabel);
        this.entryFilesBox = new ComboBox();
        this.entryFilesBox.setRenderer((ListCellRenderer)new LuaNativeComboBoxRender());
        this.entryFilesBox.addItem((Object)defaultFileItem);
        this.entryFilesBox.setBounds(second_x, maxY, second_width, lineHeight);
        this.entryFilesBox.setFont(subFont);
        this.entryFilesBox.addItemListener((ItemListener)this);
        this.rootPanel.add((Component)this.entryFilesBox);
        maxY += lineHeight;
        JLabel paramsLabel = new JLabel("Parameters");
        paramsLabel.setBounds(first_x, maxY += tabV, first_width, lineHeight);
        paramsLabel.setFont(subFont);
        this.rootPanel.add(paramsLabel);
        this.paramsTextField = new JTextField();
        this.paramsTextField.setBounds(second_x, maxY, second_width, lineHeight);
        this.paramsTextField.setFont(subFont);
        this.rootPanel.add(this.paramsTextField);
        maxY += lineHeight;
        int autoSyncLabel_w = 80;
        JLabel autoSyncLabel = new JLabel("\u81ea\u52a8\u540c\u6b65");
        autoSyncLabel.setBounds(first_x, maxY += tabV, autoSyncLabel_w, lineHeight);
        autoSyncLabel.setFont(subFont);
        this.rootPanel.add(autoSyncLabel);
        Icon onIcon = LuaNativeIconLoader.AutoSyncOnIcon;
        Icon offIcon = LuaNativeIconLoader.AutoSyncOffIcon;
        int iconWidth = onIcon.getIconWidth();
        int iconHeight = onIcon.getIconHeight();
        int toggleX = first_x + autoSyncLabel_w + 2;
        int toggleY = maxY + (lineHeight - iconHeight) / 2;
        JToggleButton toggleBtn = new JToggleButton();
        toggleBtn.setBounds(toggleX, toggleY, iconWidth, iconHeight);
        toggleBtn.setBorderPainted(false);
        toggleBtn.setSelectedIcon(onIcon);
        toggleBtn.setIcon(offIcon);
        if (this.listener != null) {
            toggleBtn.setSelected(this.listener.isAutoSyncOpen());
        }
        toggleBtn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JToggleButton toggleBtn = (JToggleButton)e.getSource();
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.setAutoSync(toggleBtn.isSelected());
                }
            }
        });
        this.rootPanel.add(toggleBtn);
        JButton reloadBtn = new JButton("\u5237\u65b0");
        reloadBtn.setBounds(maxX - btn_width, maxY, btn_width, lineHeight);
        reloadBtn.setFont(subFont);
        reloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.forceReload(EntryFileSettingsView.this.paramsTextField.getText());
                }
            }
        });
        this.rootPanel.add(reloadBtn);
        maxY += lineHeight;
        JLabel luacovLabel = new JLabel("\u5f00\u542f\u8986\u76d6\u7387\u7edf\u8ba1");
        luacovLabel.setBounds(first_x, maxY += tabV, first_width, lineHeight);
        luacovLabel.setFont(subFont);
        this.rootPanel.add(luacovLabel);
        int luacovBtnX = first_x + autoSyncLabel_w + 40;
        int luacovBtnY = maxY + (lineHeight - iconHeight) / 2;
        this.openCovButton = this.createToggleButton(luacovBtnX, luacovBtnY);
        this.openCovButton.setSelected(this.listener.isOpenLuaCoverage());
        this.openCovButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JToggleButton luacovButton = (JToggleButton)e.getSource();
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.openLuaCodeCoverage(luacovButton.isSelected());
                }
            }
        });
        this.rootPanel.add(this.openCovButton);
        JButton geneBtn = new JButton("\u751f\u6210\u7edf\u8ba1\u62a5\u544a");
        geneBtn.setBounds(maxX - btn_width, maxY, btn_width, lineHeight);
        geneBtn.setFont(subFont);
        geneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.generateCoverageReport();
                }
            }
        });
        this.rootPanel.add(geneBtn);
        maxY += lineHeight;
        JLabel precovLabel = new JLabel("\u6e05\u9664\u4e4b\u524d\u7edf\u8ba1\u7ed3\u679c");
        precovLabel.setBounds(first_x, maxY += tabV, first_width, lineHeight);
        precovLabel.setFont(subFont);
        this.rootPanel.add(precovLabel);
        int precovBtnX = first_x + autoSyncLabel_w + 40;
        int precovBtnY = maxY + (lineHeight - iconHeight) / 2;
        this.clearCovButton = this.createToggleButton(precovBtnX, precovBtnY);
        this.clearCovButton.setSelected(this.listener.isClearPreviousCoverage());
        this.clearCovButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JToggleButton precovButton = (JToggleButton)e.getSource();
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.clearPreviousCoverageResult(precovButton.isSelected());
                }
            }
        });
        this.rootPanel.add(this.clearCovButton);
        JButton detailBtn = new JButton("\u67e5\u770b\u8be6\u7ec6\u62a5\u544a");
        detailBtn.setBounds(maxX - btn_width, maxY, btn_width, lineHeight);
        detailBtn.setFont(subFont);
        detailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntryFileSettingsView.this.listener != null) {
                    EntryFileSettingsView.this.listener.generateDetailCoverageReport();
                }
            }
        });
        this.rootPanel.add(detailBtn);
        maxY += lineHeight;
        return this.rootPanel;
    }

    private JToggleButton createToggleButton(int x, int y) {
        Icon onIcon = LuaNativeIconLoader.AutoSyncOnIcon;
        Icon offIcon = LuaNativeIconLoader.AutoSyncOffIcon;
        int iconWidth = onIcon.getIconWidth();
        int iconHeight = onIcon.getIconHeight();
        JToggleButton button = new JToggleButton();
        button.setBounds(x, y, iconWidth, iconHeight);
        button.setBorderPainted(false);
        button.setSelectedIcon(onIcon);
        button.setIcon(offIcon);
        button.setSelected(false);
        return button;
    }

    public void entryFileIsUpdated() {
        this.openCovButton.setSelected(this.listener.isOpenLuaCoverage());
        this.clearCovButton.setSelected(this.listener.isClearPreviousCoverage());
    }

    @Override
    public void addEntryFile(iLuaNativeComboBoxItem item) {
        this.entryFilesBox.addItem((Object)item);
        this.entryFilesBox.setSelectedItem((Object)item);
    }

    @Override
    public void removeEntryFile(iLuaNativeComboBoxItem item) {
        this.entryFilesBox.removeItem((Object)item);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.listener != null) {
                this.listener.didSelected((iLuaNativeComboBoxItem)e.getItem(), this.paramsTextField.getText());
            }
        } else if (e.getStateChange() == 2 && this.listener != null) {
            this.listener.didDeselected((iLuaNativeComboBoxItem)e.getItem());
        }
    }
}

