/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.toolwindow.ComboBox.impl.ComboBoxDeviceItem;
import com.immomo.luanative.project.toolwindow.ComboBox.impl.LuaNativeComboBoxRender;
import com.immomo.luanative.project.toolwindow.views.iDeviceSettingView;
import com.immomo.luanative.project.toolwindow.views.iDevicesSettingListener;
import com.immomo.luanative.util.LuaNativeUtil;
import com.immomo.luanative.util.LuaQRCodeUtil;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class DevicesSettingsView
implements iDeviceSettingView {
    private final ComboBoxDeviceItem NoDeviceItem = ComboBoxDeviceItem.getDefualtInstance("  -  \u8bf7\u9009\u62e9\u8bbe\u5907  -");
    private JLabel qrCodeImageView;
    private JTextField ipTextField;
    private ComboBox iOSDevicesBox;
    private ComboBox androidDevicesBox;
    private JLabel tipLabel;
    private iDevicesSettingListener listener;

    public DevicesSettingsView(iDevicesSettingListener listener) {
        this.listener = listener;
    }

    public JComponent init() {
        JPanel deviceInfoPanel = new JPanel();
        deviceInfoPanel.setLayout(null);
        int left = 8;
        int top = 15;
        int tabH = 15;
        int tabV = 12;
        int lineHeight = 30;
        int first_width = 120;
        int second_width = 220;
        int btn_width = 100;
        final int qr_width = 120;
        int first_x = left + tabH;
        int second_x = left + tabH + first_width;
        int max_y = top;
        int maxX = second_x + second_width;
        Font subFont = new Font("Default", 0, 12);
        Font infoFont = new Font("Default", 0, 10);
        JLabel iOSLabel = new JLabel("iOS Device");
        iOSLabel.setBounds(first_x, max_y, first_width, lineHeight);
        iOSLabel.setFont(subFont);
        deviceInfoPanel.add(iOSLabel);
        this.iOSDevicesBox = new ComboBox();
        this.iOSDevicesBox.setRenderer((ListCellRenderer)new LuaNativeComboBoxRender());
        this.iOSDevicesBox.addItem((Object)this.NoDeviceItem);
        this.iOSDevicesBox.setBounds(second_x, max_y, second_width, lineHeight);
        this.iOSDevicesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !e.getItem().equals(DevicesSettingsView.this.NoDeviceItem)) {
                    if (DevicesSettingsView.this.listener != null) {
                        DevicesSettingsView.this.listener.iOSDeviceDidSelected((ComboBoxDeviceItem)e.getItem());
                    }
                } else if (e.getStateChange() == 2 && !e.getItem().equals(DevicesSettingsView.this.NoDeviceItem) && DevicesSettingsView.this.listener != null) {
                    DevicesSettingsView.this.listener.iOSDeviceDidDeselected((ComboBoxDeviceItem)e.getItem());
                }
            }
        });
        deviceInfoPanel.add((Component)this.iOSDevicesBox);
        max_y += lineHeight;
        JLabel androidLabel = new JLabel("Android Device");
        androidLabel.setBounds(first_x, max_y += tabV, first_width, lineHeight);
        androidLabel.setFont(subFont);
        deviceInfoPanel.add(androidLabel);
        this.androidDevicesBox = new ComboBox();
        this.androidDevicesBox.setRenderer((ListCellRenderer)new LuaNativeComboBoxRender());
        this.androidDevicesBox.addItem((Object)this.NoDeviceItem);
        this.androidDevicesBox.setBounds(second_x, max_y, second_width, lineHeight);
        this.androidDevicesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (DevicesSettingsView.this.listener != null && !e.getItem().equals(DevicesSettingsView.this.NoDeviceItem)) {
                        DevicesSettingsView.this.listener.androidDeviceDidSelected((ComboBoxDeviceItem)e.getItem());
                    }
                } else if (e.getStateChange() == 2 && DevicesSettingsView.this.listener != null && !e.getItem().equals(DevicesSettingsView.this.NoDeviceItem)) {
                    DevicesSettingsView.this.listener.androidDeviceDidDeselected((ComboBoxDeviceItem)e.getItem());
                }
            }
        });
        deviceInfoPanel.add((Component)this.androidDevicesBox);
        max_y += lineHeight;
        int tipH = 25;
        this.tipLabel = new JLabel();
        this.tipLabel.setBounds(first_x, max_y += tabV, maxX - btn_width - first_x - tabH, tipH);
        this.tipLabel.setFont(infoFont);
        this.tipLabel.setForeground(Color.PINK);
        this.tipLabel.setHorizontalAlignment(0);
        this.tipLabel.setOpaque(true);
        this.tipLabel.setBackground(Color.DARK_GRAY);
        this.tipLabel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        deviceInfoPanel.add(this.tipLabel);
        int x = first_x + btn_width + (maxX - 3 * btn_width - first_x) / 2;
        final JButton qrCodeBtn = new JButton("\u83b7\u53d6\u672c\u673a\u4e8c\u7ef4\u7801");
        qrCodeBtn.setFont(subFont);
        qrCodeBtn.setBounds(maxX - btn_width, max_y, btn_width, lineHeight);
        qrCodeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesSettingsView.this.qrCodeImageView.setText("\u8bf7\u7a0d\u7b49\uff0c\u83b7\u53d6\u4fe1\u606f\u4e2d...");
                DevicesSettingsView.this.qrCodeImageView.setIcon(null);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String content = LuaNativeUtil.getIpAndPort();
                        if (content != null) {
                            ImageIcon icon = LuaQRCodeUtil.generateQRCode(content, qr_width, qr_width);
                            if (icon != null) {
                                DevicesSettingsView.this.qrCodeImageView.setIcon(icon);
                                qrCodeBtn.setText("\u5237\u65b0\u672c\u673a\u4e8c\u7ef4\u7801");
                            }
                        } else {
                            content = "\u65e0\u53ef\u7528IP\u5730\u5740";
                            DevicesSettingsView.this.qrCodeImageView.setText(null);
                        }
                        DevicesSettingsView.this.ipTextField.setText(content);
                        DevicesSettingsView.this.ipTextField.setVisible(true);
                    }
                }).start();
            }
        });
        deviceInfoPanel.add(qrCodeBtn);
        max_y += lineHeight;
        x = first_x + (maxX - first_x - qr_width) / 2;
        this.qrCodeImageView = new JLabel();
        this.qrCodeImageView.setBounds(x, max_y += tabV, qr_width, qr_width);
        deviceInfoPanel.add(this.qrCodeImageView);
        this.ipTextField = new JTextField();
        this.ipTextField.setBounds(x, max_y + qr_width + 10, qr_width, tipH);
        this.ipTextField.setFont(infoFont);
        this.ipTextField.setHorizontalAlignment(0);
        this.ipTextField.setOpaque(true);
        this.ipTextField.setBackground(Color.DARK_GRAY);
        this.ipTextField.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.ipTextField.setVisible(false);
        this.ipTextField.setEditable(false);
        deviceInfoPanel.add(this.ipTextField);
        return deviceInfoPanel;
    }

    @Override
    public void addIOSDeviece(ComboBoxDeviceItem device) {
        this.iOSDevicesBox.addItem((Object)device);
        this.tipLabel.setText("\u53d1\u73b0\u65b0\u7684\u8bbe\u5907" + device.toString());
    }

    @Override
    public void removeIOSDevice(ComboBoxDeviceItem device) {
        this.iOSDevicesBox.removeItem((Object)device);
        this.tipLabel.setText("\u8bbe\u5907" + device.toString() + "\u4e0d\u53ef\u7528");
    }

    @Override
    public void addIOSDevieceList(List<ComboBoxDeviceItem> deviceList) {
        for (ComboBoxDeviceItem device : deviceList) {
            this.addIOSDeviece(device);
        }
    }

    @Override
    public void removeIOSDeviceList(List<ComboBoxDeviceItem> deviceList) {
        for (ComboBoxDeviceItem device : deviceList) {
            this.removeIOSDevice(device);
        }
    }

    @Override
    public void failToSelectIOS(ComboBoxDeviceItem device) {
        this.iOSDevicesBox.setSelectedIndex(0);
    }

    @Override
    public void addAndroidDeviece(ComboBoxDeviceItem device) {
        this.androidDevicesBox.addItem((Object)device);
        this.tipLabel.setText("\u53d1\u73b0\u65b0\u7684\u8bbe\u5907" + device.toString());
    }

    @Override
    public void removeAndroidDevice(ComboBoxDeviceItem device) {
        this.androidDevicesBox.removeItem((Object)device);
        this.tipLabel.setText("\u8bbe\u5907" + device.toString() + "\u4e0d\u53ef\u7528");
    }

    @Override
    public void addAndroidDevieceList(List<ComboBoxDeviceItem> deviceList) {
        for (ComboBoxDeviceItem device : deviceList) {
            this.addAndroidDeviece(device);
        }
    }

    @Override
    public void removeAndroidDeviceList(List<ComboBoxDeviceItem> deviceList) {
        for (ComboBoxDeviceItem device : deviceList) {
            this.removeAndroidDevice(device);
        }
    }

    @Override
    public void failToSelectAndroid(ComboBoxDeviceItem device) {
        this.androidDevicesBox.setSelectedIndex(0);
    }
}

