/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.port.LuaNativePortDocument;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.project.toolwindow.views.iPortSettingListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DevicePortSettingsView {
    private JTextField iOSTextField;
    private JTextField androidTextField;
    private JTextField netTextField;
    private iPortSettingListener listener;
    private Project project;

    public DevicePortSettingsView(Project project, iPortSettingListener listener) {
        this.project = project;
        this.listener = listener;
    }

    public JComponent init() {
        JPanel portInfoPanel = new JPanel();
        portInfoPanel.setLayout(null);
        int left = 8;
        int top = 15;
        int tabH = 15;
        int tabV = 12;
        int lineHeight = 30;
        int first_width = 120;
        int second_width = 80;
        int first_x = left + tabH;
        int second_x = left + tabH + first_width + 20;
        int max_y = top;
        Font subFont = new Font("Default", 0, 12);
        Font infoFont = new Font("Default", 0, 10);
        JLabel iOSLabel = new JLabel("iOS USB Port");
        iOSLabel.setBounds(first_x, max_y, first_width, lineHeight);
        iOSLabel.setFont(subFont);
        portInfoPanel.add(iOSLabel);
        this.iOSTextField = this.buildTextField();
        this.iOSTextField.setText(LuaNativeProjectSetting.getiOSUSBPort() + "");
        this.iOSTextField.setBounds(second_x, max_y, second_width, lineHeight);
        portInfoPanel.add(this.iOSTextField);
        max_y += lineHeight;
        JLabel androidLabel = new JLabel("Android USB Port");
        androidLabel.setBounds(first_x, max_y += tabV, first_width, lineHeight);
        androidLabel.setFont(subFont);
        portInfoPanel.add(androidLabel);
        this.androidTextField = this.buildTextField();
        this.androidTextField.setText(LuaNativeProjectSetting.getAnrdoidUSBPort() + "");
        this.androidTextField.setBounds(second_x, max_y, second_width, lineHeight);
        portInfoPanel.add(this.androidTextField);
        max_y += lineHeight;
        JLabel netLabel = new JLabel("Net Port");
        netLabel.setBounds(first_x, max_y += tabV, first_width, lineHeight);
        netLabel.setFont(subFont);
        portInfoPanel.add(netLabel);
        this.netTextField = this.buildTextField();
        this.netTextField.setText(LuaNativeProjectSetting.getNetPort() + "");
        this.netTextField.setBounds(second_x, max_y, second_width, lineHeight);
        portInfoPanel.add(this.netTextField);
        max_y += lineHeight;
        JLabel tipLabel = new JLabel("\u53ef\u7528\u7aef\u53e3\u53f7\u4e3a\uff1a5001 - 65535");
        tipLabel.setBounds(first_x, max_y += tabV, first_width + 20, lineHeight);
        tipLabel.setFont(infoFont);
        portInfoPanel.add(tipLabel);
        JButton applyBtn = new JButton();
        applyBtn.setText("\u5e94\u7528");
        applyBtn.setBounds(second_x + 20, max_y, second_width - 20, lineHeight);
        applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicePortSettingsView.this.doApply();
            }
        });
        portInfoPanel.add(applyBtn);
        return portInfoPanel;
    }

    private void doApply() {
        int ret2 = Messages.showOkCancelDialog((String)"\u5e94\u7528\u65b0\u7684\u8bbe\u7f6e\uff0c\u9700\u8981\u91cd\u542f\u5de5\u7a0b\uff0c\u786e\u5b9a\u8981\u91cd\u542f\u5417\uff1f", (String)"", (String)"\u91cd\u542f\u5de5\u7a0b", (String)"\u53d6\u6d88", (Icon)Messages.getWarningIcon());
        if (ret2 == 0 && this.listener != null) {
            this.listener.onApply(this.iOSTextField.getText(), this.androidTextField.getText(), this.netTextField.getText());
        }
    }

    private JTextField buildTextField() {
        JTextField textField = new JTextField();
        textField.setDocument(new LuaNativePortDocument());
        textField.setTransferHandler(null);
        return textField;
    }
}

