/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.toolwindow.EmbedBrowser;
import com.immomo.luanative.project.toolwindow.views.iConsoleView;
import com.immomo.luanative.project.toolwindow.views.iConsoleViewListener;
import com.immomo.luanative.project.toolwindow.views.impl.ConsoleContainerView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.StyledDocument;

public class ConsoleView
implements iConsoleView {
    private Project project;
    private JBTabbedPane rootTabbedPane = new JBTabbedPane();
    private JPanel errorPanel;
    private JLabel errorLabel;
    private boolean isShowNoConnectionView;
    private Map<String, ConsoleContainerView> containerViewsMap;
    private iConsoleViewListener listener;
    private EmbedBrowser browser;

    public ConsoleView(Project project, iConsoleViewListener listener) {
        this.project = project;
        this.listener = listener;
    }

    public JComponent init() {
        this.showNoConnectionViewIfNeed();
        return this.rootTabbedPane;
    }

    private Map<String, ConsoleContainerView> getContainerViewsMap() {
        if (this.containerViewsMap == null) {
            this.containerViewsMap = new HashMap<String, ConsoleContainerView>();
        }
        return this.containerViewsMap;
    }

    private void showNoConnectionViewIfNeed() {
        if (this.isShowNoConnectionView) {
            return;
        }
        if (this.getContainerViewsMap() == null || this.getContainerViewsMap().size() <= 0) {
            this.rootTabbedPane.removeAll();
            if (this.errorPanel == null) {
                this.createNoConnectionView();
            }
            this.rootTabbedPane.add("", (Component)this.errorPanel);
            this.isShowNoConnectionView = true;
        }
    }

    private void hiddenNoConnectionViewIfNeed() {
        if (this.isShowNoConnectionView) {
            this.rootTabbedPane.remove((Component)this.errorPanel);
            this.isShowNoConnectionView = false;
        }
    }

    private void createNoConnectionView() {
        this.errorPanel = new JPanel(new BorderLayout());
        this.errorLabel = new JLabel();
        this.errorLabel.setText("\u26a0\ufe0f\u672a\u68c0\u6d4b\u5230\u8bbe\u5907\u8fde\u63a5\uff0c\u53ef\u4f7f\u7528USB\u6570\u636e\u7ebf\u6216\u626b\u7801\u6dfb\u52a0\u8bbe\u5907");
        this.errorLabel.setHorizontalAlignment(0);
        this.errorPanel.add(this.errorLabel);
    }

    @Override
    public void addConsoleContainerView(String key, String title) {
        if (!this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = new ConsoleContainerView(this.project, key, this.listener);
            this.containerViewsMap.put(key, ccv);
            this.rootTabbedPane.add(title, (Component)ccv.init());
        }
        this.hiddenNoConnectionViewIfNeed();
    }

    @Override
    public void removeConsoleContainerView(String key) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            this.rootTabbedPane.remove((Component)ccv.getConsoleContainerPanel());
            this.containerViewsMap.remove(key);
        }
        this.showNoConnectionViewIfNeed();
    }

    @Override
    public void addMessage(String key, String msg) {
        if (this.containerViewsMap.containsKey(key)) {
            System.out.println("\u54c8\u54c8\u54c8 \u8981\u6253\u5370\u4e86");
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.addText(msg);
        }
    }

    @Override
    public void setMessage(String key, String msg) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.setText(msg);
        }
    }

    @Override
    public int getFilterType(String key) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            return ccv.getFilterType();
        }
        return 0;
    }

    @Override
    public String getFilterKey(String key) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            return ccv.getLastFilterKey();
        }
        return null;
    }

    @Override
    public void setSelected(String key, int start, int end) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.setSelected(key, start, end);
        }
    }

    @Override
    public void clearAll(String key) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.setText("");
        }
    }

    @Override
    public StyledDocument getStyledDocument(String key) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            return ccv.getStyledDocument();
        }
        return null;
    }

    @Override
    public void addMouseListener(String key, MouseListener listener) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.addMouseListener(listener);
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        for (ConsoleContainerView ccv : this.containerViewsMap.values()) {
            ccv.addMouseListener(listener);
        }
    }

    @Override
    public void scrollToPosition(String key, int position) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.scrollToPosition(position);
        }
    }

    @Override
    public void updateSearchResult(String key, String result) {
        if (this.containerViewsMap.containsKey(key)) {
            ConsoleContainerView ccv = this.containerViewsMap.get(key);
            ccv.updateSearchResult(result);
        }
    }

    @Override
    public void updateCodeCoverageSummary(String htmlPath) {
        if (this.browser == null) {
            try {
                this.browser = new EmbedBrowser();
            }
            catch (Exception e) {
                System.out.print(e.toString());
            }
        }
        this.browser.openBrowser(htmlPath);
    }
}

