/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.project.toolwindow.views.iConsoleViewListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsoleContainerView {
    private Project project;
    private JPanel consoleContainerPanel;
    private JTextPane consoleContentPane;
    private JBScrollPane consoleScrollPanel;
    private JLabel searchLabel;
    private iConsoleViewListener listener;
    private String key;
    private int filterType;
    private String lastFilterKey = "";
    private String lastSearchKey = "";
    private static final Color consoleBgColor = new Color(43, 43, 43);

    public ConsoleContainerView(Project project, String key, iConsoleViewListener listener) {
        this.project = project;
        this.listener = listener;
        this.key = key;
    }

    public JPanel init() {
        this.consoleContainerPanel = new JPanel();
        this.consoleContainerPanel.setLayout(new BorderLayout());
        this.consoleContainerPanel.add((Component)this.initTopToolBar(), "North");
        this.consoleContainerPanel.add((Component)this.initConsoleContentPane(), "Center");
        this.consoleContainerPanel.add((Component)this.initBottomToolBar(), "South");
        return this.consoleContainerPanel;
    }

    private JToolBar initTopToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        ComboBox typeBox = new ComboBox();
        typeBox.addItem((Object)"Verbose");
        typeBox.addItem((Object)"Log");
        typeBox.addItem((Object)"Error");
        typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ConsoleContainerView.this.listener != null) {
                    if (e.getItem().equals("Verbose")) {
                        ConsoleContainerView.this.filterType = 3;
                    } else if (e.getItem().equals("Error")) {
                        ConsoleContainerView.this.filterType = 2;
                    } else if (e.getItem().equals("Log")) {
                        ConsoleContainerView.this.filterType = 1;
                    }
                    ConsoleContainerView.this.listener.onFilterChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.filterType, ConsoleContainerView.this.lastFilterKey);
                }
            }
        });
        toolBar.add((Component)typeBox);
        this.filterType = 3;
        final JTextField searchBar = new JTextField();
        searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ConsoleContainerView.this.listener != null) {
                    ConsoleContainerView.this.listener.onSearchGetReturn(ConsoleContainerView.this.key, searchBar.getText());
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ConsoleContainerView.this.listener != null && !searchBar.getText().equals(ConsoleContainerView.this.lastSearchKey)) {
                    ConsoleContainerView.this.lastSearchKey = searchBar.getText();
                    ConsoleContainerView.this.listener.onSearchKeyChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.lastSearchKey);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ConsoleContainerView.this.listener != null && !searchBar.getText().equals(ConsoleContainerView.this.lastSearchKey)) {
                    ConsoleContainerView.this.lastSearchKey = searchBar.getText();
                    ConsoleContainerView.this.listener.onSearchKeyChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.lastSearchKey);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        toolBar.add(searchBar);
        this.searchLabel = new JLabel();
        toolBar.add(this.searchLabel);
        JButton cleanBtn = new JButton();
        cleanBtn.setText("\u6e05\u7a7a");
        cleanBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleContainerView.this.consoleContentPane.setText(null);
                if (ConsoleContainerView.this.listener != null) {
                    ConsoleContainerView.this.listener.onClearAll(ConsoleContainerView.this.key);
                }
            }
        });
        toolBar.add(cleanBtn);
        return toolBar;
    }

    private JComponent initConsoleContentPane() {
        this.consoleContentPane = new JTextPane();
        SimpleAttributeSet a = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(a, 0.3f);
        this.consoleContentPane.setParagraphAttributes(a, false);
        this.consoleContentPane.setMargin(new Insets(12, 10, 12, 10));
        this.consoleContentPane.setEditable(false);
        this.consoleContentPane.setBackground(consoleBgColor);
        this.consoleContentPane.setSelectionColor(Color.yellow);
        this.consoleScrollPanel = new JBScrollPane((Component)this.consoleContentPane, 22, 31);
        this.scrollToBottom();
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BorderLayout());
        myPanel.add((Component)this.consoleScrollPanel);
        return myPanel;
    }

    private JToolBar initBottomToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setMargin(new Insets(5, 150, 3, 8));
        final JTextField filterBar = new JTextField();
        filterBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ConsoleContainerView.this.listener != null && ConsoleContainerView.this.lastFilterKey != null && filterBar.getText() != null && !ConsoleContainerView.this.lastFilterKey.equals(filterBar.getText())) {
                    ConsoleContainerView.this.lastFilterKey = filterBar.getText();
                    ConsoleContainerView.this.listener.onFilterChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.filterType, ConsoleContainerView.this.lastFilterKey);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ConsoleContainerView.this.listener != null && ConsoleContainerView.this.lastFilterKey != null && filterBar.getText() != null && !ConsoleContainerView.this.lastFilterKey.equals(filterBar.getText())) {
                    ConsoleContainerView.this.lastFilterKey = filterBar.getText();
                    ConsoleContainerView.this.listener.onFilterChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.filterType, ConsoleContainerView.this.lastFilterKey);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        toolBar.add(filterBar);
        JButton cleanBtn = new JButton();
        cleanBtn.setText("\u6e05\u7a7a\u8fc7\u6ee4\u5668");
        cleanBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleContainerView.this.lastFilterKey = null;
                filterBar.setText("");
                if (ConsoleContainerView.this.listener != null) {
                    ConsoleContainerView.this.listener.onFilterChanged(ConsoleContainerView.this.key, ConsoleContainerView.this.filterType, ConsoleContainerView.this.lastFilterKey);
                }
            }
        });
        toolBar.add(cleanBtn);
        return toolBar;
    }

    public void setText(String text) {
        this.consoleContentPane.setText(text);
        this.scrollToBottom();
    }

    public void addText(String text) {
        this.consoleContentPane.setText(this.consoleContentPane.getText() + text);
        this.scrollToBottom();
    }

    public JPanel getConsoleContainerPanel() {
        return this.consoleContainerPanel;
    }

    public StyledDocument getStyledDocument() {
        return this.consoleContentPane.getStyledDocument();
    }

    public int getFilterType() {
        return this.filterType;
    }

    public String getLastFilterKey() {
        return this.lastFilterKey;
    }

    public void updateSearchResult(String result) {
        this.searchLabel.setText(result);
    }

    public void setSelected(String key, int start, int end) {
        this.consoleContentPane.setSelectionStart(start);
        this.consoleContentPane.setSelectionEnd(end);
    }

    public void scrollToPosition(int position) {
        try {
            this.consoleContentPane.scrollRectToVisible(this.consoleContentPane.modelToView(position));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.consoleContentPane.addMouseListener(listener);
    }

    private void scrollToBottom() {
        JScrollBar verticalScrollBar = this.consoleScrollPanel.getVerticalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMaximum());
    }
}

