/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views.impl;

import com.immomo.luanative.sevice.project.presenter.impl.PacketViewPresenter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class BasePacketView {
    protected static final int TITLE_SIZE = 12;
    protected static final int INFO_SIZE = 10;
    protected JCheckBox compileCheck;
    protected JCheckBox x32;
    protected JCheckBox x64;
    protected JCheckBox iOS;
    protected JCheckBox android;

    protected void compileComponent(JComponent root) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new HorizontalLayout(5));
        this.compileCheck = new JCheckBox("\u7f16\u8bd1", false);
        this.x32 = BasePacketView.newCheckBoxAndInvisible("x32");
        this.x64 = BasePacketView.newCheckBoxAndInvisible("x64");
        this.iOS = BasePacketView.newCheckBoxAndInvisible("iOS");
        this.android = BasePacketView.newCheckBoxAndInvisible("Android");
        this.compileCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BasePacketView.setVisible(BasePacketView.this.compileCheck.isSelected(), BasePacketView.this.x32, BasePacketView.this.x64, BasePacketView.this.iOS, BasePacketView.this.android);
            }
        });
        panel.add(this.compileCheck);
        panel.add(this.x32);
        panel.add(this.x64);
        panel.add(this.iOS);
        panel.add(this.android);
        root.add(panel);
    }

    protected int[] checkTypes() {
        int[] types = null;
        if (this.compileCheck.isSelected() && (types = PacketViewPresenter.getTypes(this.x32.isSelected(), this.x64.isSelected(), this.android.isSelected(), this.iOS.isSelected())) == null) {
            BasePacketView.showAlert("\u9519\u8bef\u63d0\u793a", "\u5fc5\u987b\u572832\u4f4d\u4e0e64\u4f4d\u4e2d\u9009\u62e9\u4e00\u4e2a\uff0c\u4e14\u5fc5\u987b\u5728Android\u548ciOS\u4e2d\u9009\u62e9\u4e00\u4e2a");
        }
        return types;
    }

    private static JCheckBox newCheckBoxAndInvisible(String text) {
        JCheckBox cb = new JCheckBox(text, false);
        cb.setVisible(false);
        return cb;
    }

    public static void showAlert(final String title, final String msg) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showInfoMessage((String)msg, (String)title);
            }
        });
    }

    protected static void showError(String msg) {
        BasePacketView.showAlert("\u9519\u8bef\u63d0\u793a", msg);
    }

    protected static void setVisible(boolean v, JComponent ... cs) {
        for (JComponent c : cs) {
            c.setVisible(v);
        }
    }

    protected static Font newFont(int size) {
        return new Font("Default", 0, size);
    }

    protected static int getOldHeight(JComponent c) {
        return c.getPreferredSize().height;
    }

    public abstract void onFinishPacket();
}

