/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.views;

import com.immomo.luanative.project.toolwindow.views.iDevicesSettingListener;
import com.immomo.luanative.project.toolwindow.views.iEntryFileSettingListener;
import com.immomo.luanative.project.toolwindow.views.iPortSettingListener;
import com.immomo.luanative.project.toolwindow.views.impl.DevicePortSettingsView;
import com.immomo.luanative.project.toolwindow.views.impl.DevicesSettingsView;
import com.immomo.luanative.project.toolwindow.views.impl.EntryFileSettingsView;
import com.immomo.luanative.project.toolwindow.views.impl.FepView;
import com.immomo.luanative.project.toolwindow.views.impl.PacketView;
import com.immomo.luanative.sevice.bootstrap.ServiceBootstrapFactory;
import com.immomo.luanative.sevice.bootstrap.iServiceBootstrap;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.DevicesSettingsViewPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.EntryFileSettingViewPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.FepPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.PacketViewPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.PortSettingViewPresenter;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

public class SettingsView {
    private Project project;
    private JBTabbedPane tabbedPane;
    private EntryFileSettingsView entryFileSettingsView;
    private DevicesSettingsView devicesSettingsView;
    private DevicePortSettingsView portSettingsView;
    private iViewPresenter devicesSettingsViewPresenter;
    private iViewPresenter entryFileSettingsViewPresenter;
    private iViewPresenter portSettingsViewPresenter;

    public SettingsView(Project project) {
        this.project = project;
    }

    public JComponent init() {
        this.tabbedPane = new JBTabbedPane();
        this.tabbedPane.add("Devices Info", (Component)this.initDeviceSettingView());
        this.tabbedPane.add("Entry File", (Component)this.initEntryFileSettingView());
        this.tabbedPane.add("Connection Port", (Component)this.initPortSettingView());
        this.tabbedPane.setMinimumSize(new Dimension(380, 500));
        this.tabbedPane.setMaximumSize(new Dimension(380, 600));
        return this.tabbedPane;
    }

    public JComponent initDeviceSettingView() {
        this.devicesSettingsViewPresenter = this.refer(DevicesSettingsViewPresenter.class);
        this.devicesSettingsView = new DevicesSettingsView((iDevicesSettingListener)((Object)this.devicesSettingsViewPresenter));
        JComponent component = this.devicesSettingsView.init();
        this.devicesSettingsViewPresenter.setupView(this.devicesSettingsView);
        return component;
    }

    public JComponent initEntryFileSettingView() {
        this.entryFileSettingsViewPresenter = this.refer(EntryFileSettingViewPresenter.class);
        this.entryFileSettingsView = new EntryFileSettingsView((iEntryFileSettingListener)((Object)this.entryFileSettingsViewPresenter));
        JComponent component = this.entryFileSettingsView.init();
        this.entryFileSettingsViewPresenter.setupView(this.entryFileSettingsView);
        return component;
    }

    private JComponent initPortSettingView() {
        this.portSettingsViewPresenter = this.refer(PortSettingViewPresenter.class);
        this.portSettingsView = new DevicePortSettingsView(this.project, (iPortSettingListener)((Object)this.portSettingsViewPresenter));
        JComponent component = this.portSettingsView.init();
        this.portSettingsViewPresenter.setupView(this.portSettingsView);
        return component;
    }

    private JComponent initPacketView() {
        PacketViewPresenter packetPresenter = (PacketViewPresenter)this.refer(PacketViewPresenter.class);
        PacketView packetView = new PacketView(packetPresenter);
        JComponent component = packetView.init();
        packetPresenter.setupView(packetView);
        FepView fepView = this.initFepView();
        if (fepView != null) {
            fepView.init(component);
        }
        return component;
    }

    private FepView initFepView() {
        FepPresenter presenter = (FepPresenter)this.refer(FepPresenter.class);
        if (presenter == null || !presenter.isGitInit()) {
            return null;
        }
        FepView f = new FepView(presenter);
        presenter.setupView(f);
        return f;
    }

    private iViewPresenter refer(Class serverClass) {
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(this.project);
        if (bootstrap != null) {
            return (iViewPresenter)bootstrap.bootstrap(serverClass, this.project);
        }
        return null;
    }
}

