/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow;

import com.immomo.luanative.project.toolwindow.views.SettingsView;
import com.immomo.luanative.project.toolwindow.views.iConsoleViewListener;
import com.immomo.luanative.project.toolwindow.views.iDevicesSettingListener;
import com.immomo.luanative.project.toolwindow.views.impl.ConsoleView;
import com.immomo.luanative.sevice.bootstrap.ServiceBootstrapFactory;
import com.immomo.luanative.sevice.bootstrap.iServiceBootstrap;
import com.immomo.luanative.sevice.project.presenter.iViewPresenter;
import com.immomo.luanative.sevice.project.presenter.impl.ConsoleViewPresenter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class LuaNativePanel
extends SimpleToolWindowPanel {
    public Project project;
    private SettingsView settingsView;
    private ConsoleView consoleView;
    private static final String iOSConsoleKey = "iOSConsoleKey";
    private static final String androidConsoleKey = "androidConsoleKey";
    private List<String> allConsoles = new ArrayList<String>(2);
    private iViewPresenter presenter;
    private iDevicesSettingListener listener;

    public LuaNativePanel(Project project) {
        super(false);
        this.project = project;
    }

    public void init() {
        this.setBackground(new Color(0, 0, 255));
        this.setLayout(new GridLayout(1, 2));
        JSplitPane rootSplitPane = new JSplitPane();
        rootSplitPane.setDividerLocation(0.3);
        rootSplitPane.setResizeWeight(0.3);
        rootSplitPane.setDividerSize(5);
        this.add(rootSplitPane);
        JComponent settingsCompomen = this.initSettingsCompoment();
        rootSplitPane.setLeftComponent(settingsCompomen);
        JComponent consoleCompoment = this.initConsoleCompoment();
        rootSplitPane.setRightComponent(consoleCompoment);
    }

    private JComponent initSettingsCompoment() {
        this.settingsView = new SettingsView(this.project);
        return this.settingsView.init();
    }

    private JComponent initConsoleCompoment() {
        this.presenter = this.refer(ConsoleViewPresenter.class);
        this.consoleView = new ConsoleView(this.project, (iConsoleViewListener)((Object)this.presenter));
        this.presenter.setupView(this.consoleView);
        return this.consoleView.init();
    }

    private int indexOf(String key) {
        if (!this.allConsoles.contains(key)) {
            this.allConsoles.add(key);
        }
        return this.allConsoles.indexOf(key);
    }

    public iDevicesSettingListener getListener() {
        return this.listener;
    }

    public void setListener(iDevicesSettingListener listener) {
        this.listener = listener;
    }

    private iViewPresenter refer(Class serverClass) {
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(this.project);
        if (bootstrap != null) {
            return (iViewPresenter)bootstrap.bootstrap(serverClass, this.project);
        }
        return null;
    }
}

