/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HTMLLoader
implements Runnable {
    private JPanel panel = new JPanel(new BorderLayout());
    private JFXPanel jfxPanel = new JFXPanel();
    private WebView webView;
    private WebEngine engine;
    private String htmlUrlPath;
    private boolean shoudReload;

    public HTMLLoader() {
        this.createComponents();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void render(String urlString) {
        this.shoudReload = false;
        if (this.htmlUrlPath != null && this.htmlUrlPath.equals(urlString)) {
            this.shoudReload = true;
        }
        this.htmlUrlPath = urlString;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.createRenderEngine();
        this.loadWithURLString(this.htmlUrlPath);
    }

    private void createComponents() {
        this.createRenderEngine();
        this.panel.add((Component)this.jfxPanel);
    }

    private void createRenderEngine() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (HTMLLoader.this.webView != null) {
                    return;
                }
                HTMLLoader.this.webView = new WebView();
                HTMLLoader.this.engine = HTMLLoader.this.webView.getEngine();
                HTMLLoader.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                });
                HTMLLoader.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> observableValue, Throwable old, final Throwable value) {
                        if (HTMLLoader.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String errmsg = value != null ? HTMLLoader.this.engine.getLocation() + "\n" + value.getMessage() : HTMLLoader.this.engine.getLocation() + "\nUnexpected error.";
                                    JOptionPane.showMessageDialog(HTMLLoader.this.panel, errmsg, "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                Scene scene = new Scene((Parent)HTMLLoader.this.webView);
                HTMLLoader.this.jfxPanel.setScene(scene);
                Platform.setImplicitExit((boolean)false);
            }
        });
    }

    private void loadWithURLString(final String urlString) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String urlFormString = HTMLLoader.toURLForm(urlString);
                if (urlFormString == null) {
                    urlFormString = HTMLLoader.toURLForm("http://" + urlString);
                }
                HTMLLoader.this.engine.load(urlFormString);
                if (HTMLLoader.this.shoudReload) {
                    HTMLLoader.this.engine.reload();
                }
            }
        });
    }

    private static String toURLForm(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }
}

