/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow;

import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;

public class EmbedBrowser
implements Runnable {
    private Stage primaryStage;
    private WebView webView;
    private WebEngine engine;
    private String htmlUrlPath;
    private boolean shoudReload;

    public EmbedBrowser() {
        this.createRenderEngine();
    }

    public void openBrowser(String urlString) {
        this.shoudReload = false;
        if (this.htmlUrlPath != null && this.htmlUrlPath.equals(urlString)) {
            this.shoudReload = true;
        }
        this.htmlUrlPath = urlString;
        SwingUtilities.invokeLater(this);
        this.prepareToShowStage();
    }

    @Override
    public void run() {
        this.loadWithURLString(this.htmlUrlPath);
    }

    private void prepareToShowStage() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EmbedBrowser.this.primaryStage.show();
            }
        });
    }

    private void createRenderEngine() {
        new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EmbedBrowser.this.webView != null) {
                    return;
                }
                EmbedBrowser.this.webView = new WebView();
                EmbedBrowser.this.engine = EmbedBrowser.this.webView.getEngine();
                EmbedBrowser.this.primaryStage = new Stage();
                EmbedBrowser.this.primaryStage.setTitle("MLN Code Coverage Summary");
                EmbedBrowser.this.primaryStage.show();
                EmbedBrowser.this.primaryStage.setOnCloseRequest(event -> {
                    event.consume();
                    EmbedBrowser.this.primaryStage.hide();
                });
                Scene scene = new Scene((Parent)EmbedBrowser.this.webView);
                EmbedBrowser.this.primaryStage.setScene(scene);
                Platform.setImplicitExit((boolean)false);
            }
        });
    }

    private void loadWithURLString(final String urlString) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String urlFormString = EmbedBrowser.toURLForm(urlString);
                if (urlFormString == null) {
                    urlFormString = EmbedBrowser.toURLForm("http://" + urlString);
                }
                EmbedBrowser.this.engine.load(urlFormString);
                if (EmbedBrowser.this.shoudReload) {
                    EmbedBrowser.this.engine.reload();
                }
            }
        });
    }

    private static String toURLForm(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }
}

