/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.toolwindow.ComboBox.impl;

import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.DeviceCachedFactory;
import com.immomo.luanative.project.toolwindow.ComboBox.iLuaNativeComboBoxItem;
import com.immomo.luanative.util.LuaNativeIconLoader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class ComboBoxDeviceItem
implements iLuaNativeComboBoxItem {
    private static Map<BaseDevice, ComboBoxDeviceItem> itemPool = new HashMap<BaseDevice, ComboBoxDeviceItem>();
    private BaseDevice device;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComboBoxDeviceItem getInstance(BaseDevice device) {
        ComboBoxDeviceItem item = itemPool.get(device);
        if (item == null) {
            Map<BaseDevice, ComboBoxDeviceItem> map = itemPool;
            synchronized (map) {
                if (item == null) {
                    item = new ComboBoxDeviceItem(device);
                    itemPool.put(device, item);
                }
            }
        }
        return item;
    }

    public static ComboBoxDeviceItem getDefualtInstance(String msg) {
        BaseDevice device = DeviceCachedFactory.getInstance("NONE", msg, (int)BaseDevice.USB_CONNECTION);
        device.setDeviceId(-1);
        return ComboBoxDeviceItem.getInstance(device);
    }

    public ComboBoxDeviceItem(BaseDevice device) {
        this.device = device;
    }

    public BaseDevice getDevice() {
        return this.device;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComboBoxDeviceItem) {
            ComboBoxDeviceItem otherDevice = (ComboBoxDeviceItem)obj;
            return otherDevice.device.equals(this.device);
        }
        return false;
    }

    public int hashCode() {
        return this.device.hashCode();
    }

    public String toString() {
        String name = null;
        if (this.device.getName() != null) {
            name = this.device.getName();
        }
        if (name == null && this.device.getModel() != null) {
            name = this.device.getModel();
        }
        if (name == null && this.device.getSerialNumber() != null) {
            name = this.device.getSerialNumber();
        }
        if (name != null) {
            name = "\ud83d\udcf1" + name;
        }
        if (this.device.getConnectionType().equals(BaseDevice.NET_CONNECTION)) {
            name = name + "(net)";
        } else if (this.device.getConnectionType().equals(BaseDevice.USB_CONNECTION)) {
            name = name + "(usb)";
        }
        return name;
    }

    @Override
    public Icon getIcon() {
        if (this.device.getOsType().equals("iOS")) {
            return LuaNativeIconLoader.iOSIcon;
        }
        if (this.device.getOsType().equals("Android")) {
            return LuaNativeIconLoader.AndroidIcon;
        }
        return null;
    }

    @Override
    public String getText() {
        String name = null;
        if (this.device.getName() != null) {
            name = this.device.getName();
        }
        if (name == null && this.device.getModel() != null) {
            name = this.device.getModel();
        }
        if (name == null && this.device.getSerialNumber() != null) {
            name = this.device.getSerialNumber();
        }
        if (this.device.getConnectionType().equals(BaseDevice.NET_CONNECTION)) {
            name = name + "(net)";
        } else if (this.device.getConnectionType().equals(BaseDevice.USB_CONNECTION) && (this.device.getOsType().equals("iOS") || this.device.getOsType().equals("Android"))) {
            name = name + "(usb)";
        }
        return name;
    }
}

