/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.handler;

import com.immomo.luanative.util.LuaNativeFileUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextPane;
import javax.swing.text.Element;

public class FileLinkHandler
implements MouseListener {
    private Project project;
    private LuaNativeFileUtil fileUtil;

    public FileLinkHandler(Project project) {
        this.project = project;
        this.fileUtil = new LuaNativeFileUtil(project);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String filePath;
        if (!this.isLinkLuaFile(e)) {
            return;
        }
        Element element = this.getMouseElement(e);
        String file = this.getLinkLuaFile(element);
        String line = this.getLinkLuaLine(element);
        int lineCount = 0;
        if (line != null && line != "null") {
            try {
                lineCount = Integer.parseInt(line);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((filePath = this.fileUtil.getAbsoluteFilePath(file)) != null) {
            this.openFile(filePath, lineCount);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isLinkLuaFile(e)) {
            return;
        }
        e.getComponent().setCursor(new Cursor(12));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isLinkLuaFile(e)) {
            return;
        }
        e.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void openFile(String fileUrl, int line) {
        if (fileUrl == null || !(fileUrl instanceof String) || fileUrl.length() <= 0) {
            return;
        }
        try {
            VirtualFile vfs = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
            if (vfs != null) {
                OpenFileDescriptor opDes = new OpenFileDescriptor(this.project, vfs, line - 1, 1);
                FileEditorManager.getInstance((Project)this.project).openTextEditor(opDes, true);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    private Element getMouseElement(MouseEvent e) {
        JTextPane sourceTextPane = (JTextPane)e.getComponent();
        int pos = sourceTextPane.viewToModel(e.getPoint());
        Element element = sourceTextPane.getStyledDocument().getCharacterElement(pos);
        return element;
    }

    private boolean isLinkLuaFile(MouseEvent e) {
        Element element = this.getMouseElement(e);
        String st = this.getLinkLuaFile(element);
        return st != null && st != "null";
    }

    private String getLinkLuaFile(Element element) {
        return String.valueOf(element.getAttributes().getAttribute("file"));
    }

    private String getLinkLuaLine(Element element) {
        return String.valueOf(element.getAttributes().getAttribute("line"));
    }
}

