/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.file;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LuaEntryFilePersistentHelper", storages={@Storage(value="luanative.xml")})
public class LuaEntryFilePersistentHelper
implements PersistentStateComponent<LuaEntryFilePersistentHelper> {
    private Project project;
    private ArrayList<String> entryFileList = new ArrayList();

    public LuaEntryFilePersistentHelper() {
    }

    public LuaEntryFilePersistentHelper(Project project) {
        this.project = project;
    }

    public static LuaEntryFilePersistentHelper getInstance(Project project) {
        if (project.isDisposed()) {
            return null;
        }
        return (LuaEntryFilePersistentHelper)ServiceManager.getService((Project)project, LuaEntryFilePersistentHelper.class);
    }

    public void addEntryFile(VirtualFile file) {
        if (file == null) {
            return;
        }
        this.addEntryFile(file.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntryFile(String filePath) {
        if (filePath == null) {
            return;
        }
        if (this.isEntryFile(filePath)) {
            return;
        }
        LuaEntryFilePersistentHelper luaEntryFilePersistentHelper = this;
        synchronized (luaEntryFilePersistentHelper) {
            this.getEntryFileList().add(filePath);
            this.project.save();
        }
    }

    public void removeEntryFile(VirtualFile file) {
        if (file == null) {
            return;
        }
        this.removeEntryFile(file.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntryFile(String filePath) {
        if (filePath == null) {
            return;
        }
        LuaEntryFilePersistentHelper luaEntryFilePersistentHelper = this;
        synchronized (luaEntryFilePersistentHelper) {
            this.getEntryFileList().remove(filePath);
            this.project.save();
        }
    }

    public void changeEntryFile(VirtualFile file, String oldFilePath) {
        if (file == null || oldFilePath == null) {
            return;
        }
        this.changeEntryFile(file.getUrl(), oldFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEntryFile(String newFilePath, String oldFilePath) {
        if (newFilePath == null || oldFilePath == null) {
            return;
        }
        LuaEntryFilePersistentHelper luaEntryFilePersistentHelper = this;
        synchronized (luaEntryFilePersistentHelper) {
            int idx = this.getEntryFileList().indexOf(oldFilePath);
            if (idx != -1) {
                this.getEntryFileList().set(idx, newFilePath);
                this.project.save();
            }
        }
    }

    public boolean isEntryFile(VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.isEntryFile(file.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntryFile(String filePath) {
        boolean isEntryFile;
        if (filePath == null) {
            return false;
        }
        LuaEntryFilePersistentHelper luaEntryFilePersistentHelper = this;
        synchronized (luaEntryFilePersistentHelper) {
            isEntryFile = this.getEntryFileList().contains(filePath);
        }
        return isEntryFile;
    }

    @Nullable
    public LuaEntryFilePersistentHelper getState() {
        return this;
    }

    public void loadState(@NotNull LuaEntryFilePersistentHelper state2) {
        if (state2 == null) {
            LuaEntryFilePersistentHelper.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public ArrayList<String> getEntryFileList() {
        return this.entryFileList;
    }

    public void setEntryFileList(ArrayList<String> entryFileList) {
        this.entryFileList = entryFileList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/immomo/luanative/project/file/LuaEntryFilePersistentHelper", "loadState"));
    }
}

