/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.project.actions;

import com.immomo.luanative.sevice.bootstrap.ServiceBootstrapFactory;
import com.immomo.luanative.sevice.bootstrap.iServiceBootstrap;
import com.immomo.luanative.sevice.project.file.entryfile.LuaEntryFileManager;
import com.immomo.luanative.util.LuaNativeFileUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntryFileAction
extends AnAction {
    private Map<Project, LuaNativeFileUtil> fileUtilMap = new HashMap<Project, LuaNativeFileUtil>();

    public abstract void handleAction(Project var1, VirtualFile var2);

    public abstract boolean isVisible(Project var1, VirtualFile var2);

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            AbstractEntryFileAction.$$$reportNull$$$0(0);
        }
        Project project = anActionEvent.getProject();
        VirtualFile file = (VirtualFile)anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE);
        this.handleAction(project, file);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractEntryFileAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        boolean isVisible = this.isVisible(e);
        e.getPresentation().setVisible(isVisible);
    }

    public boolean isVisible(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractEntryFileAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null || file.isDirectory()) {
            return false;
        }
        String filePath = file.getUrl();
        if (filePath == null) {
            return false;
        }
        if (!this.isRootFile(project, filePath)) {
            return false;
        }
        if (!LuaNativeFileUtil.isLuaFile(filePath)) {
            return false;
        }
        return this.isVisible(project, file);
    }

    protected boolean isRootFile(Project project, String filePath) {
        LuaNativeFileUtil fileUtil = this.fileUtilMap.get(project);
        if (fileUtil == null) {
            fileUtil = new LuaNativeFileUtil(project);
            this.fileUtilMap.put(project, fileUtil);
        }
        return fileUtil.isRootFile(filePath);
    }

    protected void addEntryFile(Project project, VirtualFile file) {
        LuaEntryFileManager fileManager;
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(project);
        if (bootstrap != null && (fileManager = (LuaEntryFileManager)bootstrap.bootstrap(LuaEntryFileManager.class, project)) != null) {
            fileManager.addEntryFile(file.getUrl());
        }
    }

    protected void removeEntryFile(Project project, VirtualFile file) {
        LuaEntryFileManager fileManager;
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(project);
        if (bootstrap != null && (fileManager = (LuaEntryFileManager)bootstrap.bootstrap(LuaEntryFileManager.class, project)) != null) {
            fileManager.removeEntryFile(file.getUrl());
        }
    }

    protected boolean isEntryFile(Project project, VirtualFile file) {
        LuaEntryFileManager fileManager;
        iServiceBootstrap bootstrap = ServiceBootstrapFactory.getProjectInstance(project);
        if (bootstrap != null && (fileManager = (LuaEntryFileManager)bootstrap.bootstrap(LuaEntryFileManager.class, project)) != null) {
            return fileManager.isEntryFile(file.getUrl());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anActionEvent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/immomo/luanative/project/actions/AbstractEntryFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

