/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.io;

import com.immomo.luanative.client.iClient;
import com.immomo.luanative.codec.encode.EncoderFactory;
import com.immomo.luanative.codec.encode.iEncoder;
import com.immomo.luanative.io.iSender;
import com.immomo.luanative.io.iSenderListener;
import com.immomo.luanative.sevice.AbstractService;
import com.intellij.openapi.application.ApplicationManager;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class AbstractSender
extends AbstractService
implements iSender,
Runnable {
    protected iSenderListener listener;
    private iClient client;
    private BlockingQueue<Object> msgQueue = new LinkedBlockingDeque<Object>();
    private iEncoder encoder = EncoderFactory.getInstance();
    private Object lock = new Object();

    public AbstractSender(iClient client) {
        this.client = client;
    }

    protected abstract <T> void write(T var1) throws IOException;

    protected abstract void flush() throws IOException;

    protected abstract void close() throws IOException;

    @Override
    protected boolean onStart() {
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
        return true;
    }

    @Override
    protected boolean onStop() {
        return true;
    }

    @Override
    public void setListener(iSenderListener listener) {
        this.listener = listener;
    }

    @Override
    public <T> void send(T message2) {
        this.pushMsg(message2);
    }

    @Override
    public iClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean needFlush = false;
        while (this.isRunning()) {
            while (this.msgQueue.size() > 0) {
                byte[] data;
                Object msg = this.popMsg();
                if (msg == null || (data = this.encoder.encode(msg)) == null || data.length <= 0) continue;
                System.out.println(">>>>>>> message to ");
                try {
                    this.write(data);
                    System.out.println(">>>>>>> \u53d1\u6d88\u606f\u4e86 " + data.length);
                    needFlush = true;
                }
                catch (IOException e) {
                    this.notifyError(e.getMessage());
                    return;
                }
            }
            if (!needFlush) continue;
            needFlush = false;
            try {
                this.flush();
            }
            catch (IOException e) {
                this.notifyError(e.getMessage());
                return;
            }
            Object e = this.lock;
            synchronized (e) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e2) {
                    this.notifyError(e2.getMessage());
                    return;
                }
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            this.notifyError(e.getMessage());
            return;
        }
    }

    private Object popMsg() {
        try {
            return this.msgQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushMsg(Object msg) {
        try {
            this.msgQueue.put(msg);
            System.out.println(">>> push \u6d88\u606f" + this.client + this);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void notifyError(String errmsg) {
        if (this.listener != null) {
            this.listener.onFailToSend(-1, errmsg);
        }
    }
}

