/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.io;

import com.immomo.luanative.client.iClient;
import com.immomo.luanative.codec.decode.DecoderFactory;
import com.immomo.luanative.codec.decode.iDecoder;
import com.immomo.luanative.codec.decode.iDecodingListener;
import com.immomo.luanative.io.iReader;
import com.immomo.luanative.io.iReaderListener;
import com.immomo.luanative.sevice.AbstractService;
import com.intellij.openapi.application.ApplicationManager;
import java.io.IOException;

public abstract class AbstractReader
extends AbstractService
implements iReader,
Runnable,
iDecodingListener {
    protected static final int READ_BUFFER_SIZE = 0x100000;
    protected iReaderListener listener;
    protected iClient client;
    protected iDecoder decoder = DecoderFactory.getInstance(this);

    public AbstractReader(iClient client) {
        this.client = client;
    }

    protected abstract byte[] read() throws IOException;

    protected abstract void close() throws IOException;

    @Override
    protected boolean onStart() {
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
        return true;
    }

    @Override
    protected boolean onStop() {
        return true;
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            this.handleRead();
        }
        try {
            this.close();
        }
        catch (IOException e) {
            this.notifyError(e.getMessage());
        }
    }

    @Override
    public int checkRead() {
        return this.handleRead();
    }

    @Override
    public void onRecieve(iReaderListener listener) {
        this.listener = listener;
    }

    @Override
    public iClient getClient() {
        return this.client;
    }

    @Override
    public void onDecoding(Object obj) {
        if (this.listener != null) {
            this.listener.onMessage(obj);
        }
    }

    private int handleRead() {
        try {
            byte[] buffer = this.read();
            this.decoder.push(buffer);
            return buffer.length;
        }
        catch (IOException e) {
            this.notifyError(e.getMessage());
            return -1;
        }
    }

    protected void notifyError(String errmsg) {
        if (this.listener != null) {
            this.listener.onFailToRead(-1, errmsg);
        }
    }
}

