/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.device;

import com.immomo.luanative.codec.protobuf.PBBaseCommand;
import com.immomo.luanative.codec.protobuf.PBDeviceCommand;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.device.impl.AndroidDeviceImpl;
import com.immomo.luanative.device.impl.IOSDeviceImpl;
import com.mogaleaf.usbmuxd.api.model.Device;
import java.util.HashMap;
import java.util.Map;

public class DeviceCachedFactory {
    private static final Map<String, BaseDevice> devicePool = new HashMap<String, BaseDevice>();

    public static BaseDevice getInstance(PBDeviceCommand.pbdevicecommand cmd, int connectionType) {
        PBBaseCommand.pbbasecommand baseCmd = cmd.getBasecommand();
        String cacheKey = DeviceCachedFactory.getCacheKey(baseCmd.getSerialNumber(), connectionType);
        BaseDevice device = DeviceCachedFactory.get(cacheKey);
        if (device == null) {
            if (baseCmd.getOsType().equals("iOS")) {
                device = new IOSDeviceImpl();
            } else if (baseCmd.getOsType().equals("Android")) {
                device = new AndroidDeviceImpl();
            }
            DeviceCachedFactory.set(cacheKey, device);
        }
        device.setSerialNumber(baseCmd.getSerialNumber());
        device.setConnectionType(connectionType);
        device.setModel(cmd.getModel());
        device.setName(cmd.getName());
        return device;
    }

    public static BaseDevice getInstance(PBDeviceCommand.pbdevicecommand cmd, int connectionType, Object extraData) {
        PBBaseCommand.pbbasecommand baseCmd = cmd.getBasecommand();
        String cacheKey = DeviceCachedFactory.getCacheKey(baseCmd.getSerialNumber(), connectionType);
        BaseDevice device = DeviceCachedFactory.get(cacheKey);
        if (device == null) {
            if (baseCmd.getOsType().equals("iOS")) {
                device = new IOSDeviceImpl();
            } else if (baseCmd.getOsType().equals("Android")) {
                device = new AndroidDeviceImpl();
            }
            DeviceCachedFactory.set(cacheKey, device);
        }
        device.setSerialNumber(baseCmd.getSerialNumber());
        device.setConnectionType(connectionType);
        device.setModel(cmd.getModel());
        device.setName(cmd.getName());
        device.setExtraData(extraData);
        return device;
    }

    public static BaseDevice getInstance(Device device, int connectionType) {
        String cacheKey = DeviceCachedFactory.getCacheKey(device.serialNumber, connectionType);
        IOSDeviceImpl iOSDevice = (IOSDeviceImpl)DeviceCachedFactory.get(cacheKey);
        if (iOSDevice == null) {
            iOSDevice = new IOSDeviceImpl();
            DeviceCachedFactory.set(cacheKey, iOSDevice);
        }
        iOSDevice.setDeviceId(device.deviceId);
        iOSDevice.setSerialNumber(device.serialNumber);
        iOSDevice.setConnectionType(connectionType);
        iOSDevice.setExtraData(device);
        return iOSDevice;
    }

    public static BaseDevice getInstance(String osType, String serialNumber, int connectionType) {
        String cacheKey = DeviceCachedFactory.getCacheKey(serialNumber, connectionType);
        BaseDevice device = DeviceCachedFactory.get(cacheKey);
        if (device == null) {
            if (osType.equals("iOS")) {
                device = new IOSDeviceImpl();
            } else if (osType.equals("Android")) {
                device = new AndroidDeviceImpl();
            } else {
                device = new BaseDevice();
                device.setOsType(osType);
            }
            DeviceCachedFactory.set(cacheKey, device);
        }
        device.setSerialNumber(serialNumber);
        device.setConnectionType(connectionType);
        return device;
    }

    public static BaseDevice getInstance(String osType, String[] info, int connectionType) {
        BaseDevice device = null;
        if (osType.equals("Android") && info[1].equals("device")) {
            String serialNumber = info[0];
            String cacheKey = DeviceCachedFactory.getCacheKey(serialNumber, connectionType);
            device = DeviceCachedFactory.get(cacheKey);
            if (device == null) {
                device = new AndroidDeviceImpl();
                DeviceCachedFactory.set(cacheKey, device);
            }
            device.setSerialNumber(serialNumber);
            for (String msg : info) {
                if (msg.startsWith("model:")) {
                    device.setModel(msg.replace("model:", ""));
                }
                if (!msg.startsWith("transport_id:")) continue;
                device.setDeviceId(Integer.parseInt(msg.replace("transport_id:", "")));
            }
            device.setConnectionType(connectionType);
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BaseDevice get(String key) {
        Map<String, BaseDevice> map = devicePool;
        synchronized (map) {
            return devicePool.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void set(String key, BaseDevice device) {
        Map<String, BaseDevice> map = devicePool;
        synchronized (map) {
            devicePool.put(key, device);
        }
    }

    private static String getCacheKey(String sn, int connectionType) {
        return sn + "_connection_type_" + connectionType;
    }
}

