/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.conn;

import com.immomo.luanative.codec.PBCommandFactory;
import com.immomo.luanative.codec.decode.DecoderFactory;
import com.immomo.luanative.codec.decode.iDecoder;
import com.immomo.luanative.codec.decode.iDecodingListener;
import com.immomo.luanative.codec.encode.EncoderFactory;
import com.immomo.luanative.codec.encode.iEncoder;
import com.immomo.luanative.codec.protobuf.PBDeviceCommand;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.util.LuaNativeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public class LuaNativeTransportUtil {
    private static Socket androidSocket;
    private static Socket iOSSocket;
    private static Map<BaseDevice, SocketChannel> netSocketChannelMap;
    static PBDeviceCommand.pbdevicecommand responsecCmd;

    public static Socket createSocket(BaseDevice device) throws IOException {
        if (device.getOsType().equals("iOS") && device.getConnectionType() == BaseDevice.USB_CONNECTION) {
            if (iOSSocket != null) {
                iOSSocket.close();
            }
            iOSSocket = LuaNativeTransportUtil.createIOSSocket(device);
            return iOSSocket;
        }
        if (device.getOsType().equals("Android") && device.getConnectionType() == BaseDevice.USB_CONNECTION) {
            if (androidSocket != null) {
                androidSocket.close();
            }
            androidSocket = LuaNativeTransportUtil.createAndroidSocket(device);
            return androidSocket;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketChannel getSocketChannel(BaseDevice device) {
        Map<BaseDevice, SocketChannel> map = netSocketChannelMap;
        synchronized (map) {
            return netSocketChannelMap.get(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(BaseDevice device, SocketChannel socketChannel) {
        Map<BaseDevice, SocketChannel> map = netSocketChannelMap;
        synchronized (map) {
            netSocketChannelMap.put(device, socketChannel);
        }
    }

    private static Socket createAndroidSocket(BaseDevice device) throws IOException {
        InetAddress serverAddr = InetAddress.getByName("127.0.0.1");
        androidSocket = new Socket(serverAddr, LuaNativeProjectSetting.getAnrdoidUSBPort());
        androidSocket.setTcpNoDelay(true);
        return androidSocket;
    }

    private static Socket createIOSSocket(BaseDevice device) throws IOException {
        Socket connectionSocket = LuaNativeTransportUtil.getSocketImpl();
        connectionSocket.connect(LuaNativeTransportUtil.getAddress());
        iOSSocket = connectionSocket;
        return iOSSocket;
    }

    private static SocketAddress getAddress() throws IOException {
        return new AFUNIXSocketAddress(new File("/var/run/usbmuxd"));
    }

    private static Socket getSocketImpl() throws IOException {
        return AFUNIXSocket.newInstance();
    }

    public static void syncDeiveInfo(final BaseDevice device, InputStream inputStream, OutputStream outputStream) throws IOException {
        iEncoder encoder;
        byte[] data;
        byte[] buffer = new byte[0x100000];
        int readSize = 0;
        readSize = inputStream.read(buffer);
        iDecoder decoder = DecoderFactory.getInstance(new iDecodingListener(){

            @Override
            public void onDecoding(Object obj) {
                if (obj instanceof PBDeviceCommand.pbdevicecommand) {
                    PBDeviceCommand.pbdevicecommand cmd = (PBDeviceCommand.pbdevicecommand)obj;
                    device.setModel(cmd.getModel());
                    device.setName(cmd.getName());
                    responsecCmd = (PBDeviceCommand.pbdevicecommand)PBCommandFactory.getDeviceCommand(device);
                }
            }
        });
        decoder.push(LuaNativeUtil.getBytes(buffer, 0, readSize));
        if (responsecCmd != null && (data = (encoder = EncoderFactory.getInstance()).encode(responsecCmd)) != null && data.length > 0) {
            outputStream.write(data);
            outputStream.flush();
        }
    }

    static {
        netSocketChannelMap = new HashMap<BaseDevice, SocketChannel>();
    }
}

