/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.codec.decode.impl;

import com.immomo.luanative.codec.decode.AbstractDecoder;
import com.immomo.luanative.codec.decode.iDecodingListener;
import com.immomo.luanative.codec.protobuf.PBMessageFactory;
import com.immomo.luanative.util.LuaNativeUtil;

public class DecoderImpl
extends AbstractDecoder {
    private byte[] rawData;
    private iDecodingListener listener;

    @Override
    public void push(byte[] data) {
        try {
            this.decode(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDecoding(iDecodingListener listener) {
        this.listener = listener;
    }

    public void decode(byte[] data) throws Exception {
        this.rawData = this.rawData != null ? LuaNativeUtil.mergeBytes(this.rawData, data) : data;
        this.rawData = this.decodeMessage(this.rawData);
    }

    private byte[] decodeMessage(byte[] data) throws Exception {
        byte pkgType = this.unpackType(data);
        int headerLength = this.unpackHeaderLength(pkgType);
        int bodyType = this.unpackBodyType(data, pkgType);
        int bodyLength = this.unpackBodyLength(data, pkgType);
        int completedLength = headerLength + bodyLength + 1;
        if (data.length > completedLength) {
            int remainLength = data.length - completedLength;
            byte[] remainData = LuaNativeUtil.getBytes(data, completedLength, remainLength);
            byte[] completedData = LuaNativeUtil.getBytes(data, headerLength, bodyLength);
            Object obj = PBMessageFactory.getInstance(bodyType, completedData);
            if (this.listener != null) {
                this.listener.onDecoding(obj);
            }
            return this.decodeMessage(remainData);
        }
        if (data.length == completedLength) {
            byte[] packageData = LuaNativeUtil.getBytes(data, headerLength, bodyLength);
            Object obj = PBMessageFactory.getInstance(bodyType, packageData);
            if (this.listener != null) {
                this.listener.onDecoding(obj);
            }
            return null;
        }
        return data;
    }

    private byte unpackType(byte[] data) throws Exception {
        if (data.length > 0) {
            return data[0];
        }
        return -1;
    }

    private int unpackHeaderLength(int pkgType) throws Exception {
        switch (pkgType) {
            case 2: {
                return 7;
            }
            case 3: {
                return 7;
            }
            case 1: {
                return 9;
            }
        }
        return -1;
    }

    private int unpackBodyType(byte[] data, int pkgType) throws Exception {
        switch (pkgType) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return this.unpackInt(data, 1, 4);
    }

    private int unpackBodyLength(byte[] data, int pkgType) throws Exception {
        switch (pkgType) {
            case 2: 
            case 3: {
                return 0;
            }
        }
        return this.unpackInt(data, 5, 8);
    }
}

