/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.client.impl;

import com.immomo.luanative.client.AbstractClient;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.client.iClientListener;
import com.immomo.luanative.conn.LuaNativeTransportUtil;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.io.ReaderFactory;
import com.immomo.luanative.io.SenderFactory;
import com.immomo.luanative.io.iReader;
import com.immomo.luanative.io.iSender;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.mogaleaf.usbmuxd.api.exception.UsbMuxdConnectException;
import com.mogaleaf.usbmuxd.protocol.ConnectedMessage;
import com.mogaleaf.usbmuxd.protocol.DeviceConnecter;
import com.mogaleaf.usbmuxd.protocol.PlistMessageService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class IOSUSBClientImpl
extends AbstractClient {
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private DeviceConnecter deviceConnecter = new DeviceConnecter();

    public IOSUSBClientImpl(iClientListener listener, BaseDevice device) {
        super(listener, device);
    }

    @Override
    protected boolean onConnect() throws Exception {
        this.socket = LuaNativeTransportUtil.createSocket(this.getDevice());
        byte[] connectByteMessage = PlistMessageService.buildConnectMsg(this.getDevice().getDeviceId(), LuaNativeProjectSetting.getiOSUSBPort());
        this.inputStream = this.socket.getInputStream();
        Future<ConnectedMessage> submit = this.executorService.submit(() -> this.deviceConnecter.getConnectionResult(this.inputStream));
        this.outputStream = this.socket.getOutputStream();
        this.outputStream.write(connectByteMessage);
        ConnectedMessage connectedMessage = submit.get();
        if (connectedMessage.result != 0) {
            try {
                connectedMessage.throwException();
            }
            catch (UsbMuxdConnectException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        LuaNativeTransportUtil.syncDeiveInfo(this.getDevice(), this.inputStream, this.outputStream);
        return true;
    }

    @Override
    protected void onDisconnect() throws Exception {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    protected iReader buildReader() {
        return ReaderFactory.getInstance((iClient)this, this.inputStream);
    }

    @Override
    protected iSender buildSender() {
        return SenderFactory.getInstance((iClient)this, this.outputStream);
    }

    @Override
    public String getClientType() {
        return "CLIENT_USB";
    }
}

