/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.client.impl;

import com.immomo.luanative.client.AbstractClient;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.client.iClientListener;
import com.immomo.luanative.conn.LuaNativeTransportUtil;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.io.ReaderFactory;
import com.immomo.luanative.io.SenderFactory;
import com.immomo.luanative.io.iReader;
import com.immomo.luanative.io.iSender;
import com.immomo.luanative.project.port.LuaNativeProjectSetting;
import com.immomo.luanative.util.adb.AdbUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class AndroidUSBClientImpl
extends AbstractClient {
    private Socket socket = null;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static boolean needForward = true;

    public AndroidUSBClientImpl(iClientListener listener, BaseDevice device) {
        super(listener, device);
    }

    @Override
    protected boolean onConnect() throws Exception {
        int dstPort;
        int srcPort = LuaNativeProjectSetting.getAnrdoidUSBPort();
        if (!AdbUtil.checkPortForward(srcPort, dstPort = LuaNativeProjectSetting.getAnrdoidUSBPort())) {
            AdbUtil.doPortForward(srcPort, dstPort);
        }
        this.socket = LuaNativeTransportUtil.createSocket(this.getDevice());
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        return true;
    }

    @Override
    protected void onDisconnect() throws Exception {
        needForward = true;
        AdbUtil.removePortForward(LuaNativeProjectSetting.getAnrdoidUSBPort());
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    protected iReader buildReader() {
        return ReaderFactory.getInstance((iClient)this, this.inputStream);
    }

    @Override
    protected iSender buildSender() {
        return SenderFactory.getInstance((iClient)this, this.outputStream);
    }

    @Override
    public String getClientType() {
        return "CLIENT_USB";
    }
}

