/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.client;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.client.channel.MessageChannel;
import com.immomo.luanative.client.iClient;
import com.immomo.luanative.client.iClientListener;
import com.immomo.luanative.codec.PBCommandFactory;
import com.immomo.luanative.codec.protobuf.PBPingCommand;
import com.immomo.luanative.device.BaseDevice;
import com.immomo.luanative.io.iReader;
import com.immomo.luanative.io.iReaderListener;
import com.immomo.luanative.io.iSender;
import com.immomo.luanative.io.iSenderListener;

public abstract class AbstractClient
implements iClient,
iReaderListener,
iSenderListener {
    protected iClientListener listener;
    private BaseDevice device;
    protected iReader reader;
    protected iSender sender;
    protected MessageChannel readerChannel;
    protected MessageChannel senderChannel;
    private boolean myConnected = false;

    public AbstractClient(iClientListener listener, BaseDevice device) {
        this.listener = listener;
        this.device = device;
    }

    protected abstract boolean onConnect() throws Exception;

    protected abstract void onDisconnect() throws Exception;

    protected abstract iReader buildReader();

    protected abstract iSender buildSender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        if (!this.myConnected) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                if (!this.myConnected) {
                    this.myConnected = true;
                    this.openChannels();
                    try {
                        this.myConnected = this.onConnect();
                    }
                    catch (Exception e) {
                        this.notifyOnError(e.getMessage());
                    }
                    if (this.myConnected) {
                        this.startReaderAndSender();
                        this.notifyOnConnected();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.myConnected) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                if (this.myConnected) {
                    this.closeChannels();
                    this.closeReaderAndSender();
                    try {
                        this.onDisconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.myConnected = false;
                        this.notifyOnDisconnect();
                    }
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.myConnected;
    }

    @Override
    public BaseDevice getDevice() {
        return this.device;
    }

    @Override
    public void onFailToRead(int code, String errmsg) {
        if (this.reader != null) {
            this.reader.stop();
        }
        this.notifyOnError(errmsg);
    }

    @Override
    public <T> void onMessage(T message2) {
        if (message2 instanceof PBPingCommand.pbpingcommand) {
            this.sender.send(PBCommandFactory.getPongCommand("123", 999));
        } else {
            this.notifyOnMessage(message2);
        }
    }

    @Override
    public void onFailToSend(int code, String errmsg) {
        if (this.sender != null) {
            this.sender.stop();
        }
        this.notifyOnError(errmsg);
    }

    private void openChannels() {
        this.readerChannel = (MessageChannel)MessageChannel.getRecieveInstance(this);
        this.senderChannel = (MessageChannel)MessageChannel.getSendInstance(this);
        this.senderChannel.onMessage(new iBroadcastChannelListener(){

            @Override
            public void onMessage(iMessageEvent event) {
                Object data = event.getData();
                if (data != null) {
                    AbstractClient.this.sender.send(data);
                }
            }
        });
    }

    private void closeChannels() {
        if (this.readerChannel != null) {
            this.readerChannel.close();
        }
        if (this.senderChannel != null) {
            this.senderChannel.close();
        }
    }

    private void startReaderAndSender() {
        this.reader = this.buildReader();
        if (this.reader != null) {
            this.reader.onRecieve(this);
            this.reader.start();
        }
        this.sender = this.buildSender();
        if (this.sender != null) {
            this.sender.setListener(this);
            this.sender.start();
        }
    }

    private void closeReaderAndSender() {
        if (this.reader != null) {
            this.reader.stop();
        }
        if (this.sender != null) {
            this.sender.stop();
        }
    }

    protected void notifyOnConnected() {
        if (this.listener != null) {
            this.listener.onConnected(this);
        }
    }

    protected void notifyOnDisconnect() {
        if (this.listener != null) {
            this.listener.disconnect(this);
        }
    }

    protected void notifyOnError(String errmsg) {
        if (this.listener != null) {
            this.listener.onError(this, errmsg);
        }
    }

    protected <T> void notifyOnMessage(T msg) {
        if (this.readerChannel != null) {
            this.readerChannel.post(msg);
        }
    }
}

