/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.broadcastchannel.dispatcher.impl;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.dispatcher.iBroadcastChannelDispatcher;
import com.immomo.luanative.broadcastchannel.dispatcher.impl.DispatchTask;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;
import com.immomo.luanative.sevice.AbstractService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class BroadcastChannelDispatcher
extends AbstractService
implements iBroadcastChannelDispatcher,
Runnable {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Map<String, List<iBroadcastChannel>> channelMap = new HashMap<String, List<iBroadcastChannel>>();
    private BlockingQueue<DispatchTask> taskQueue = new LinkedBlockingDeque<DispatchTask>();

    @Override
    protected boolean onStart() {
        this.executorService.execute(this);
        return true;
    }

    @Override
    protected boolean onStop() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join(iBroadcastChannel channel) {
        if (channel != null) {
            BroadcastChannelDispatcher broadcastChannelDispatcher = this;
            synchronized (broadcastChannelDispatcher) {
                List<iBroadcastChannel> channels = this.channelMap.get(channel.getName());
                if (channels == null) {
                    channels = new ArrayList<iBroadcastChannel>();
                    this.channelMap.put(channel.getName(), channels);
                }
                if (!channels.contains(channel)) {
                    channels.add(channel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(iBroadcastChannel channel) {
        if (channel != null) {
            BroadcastChannelDispatcher broadcastChannelDispatcher = this;
            synchronized (broadcastChannelDispatcher) {
                List<iBroadcastChannel> channels = this.channelMap.get(channel.getName());
                if (channels != null) {
                    channels.remove(channel);
                }
            }
        }
    }

    @Override
    public void notify(iBroadcastChannel channel, iMessageEvent event) {
        List<iBroadcastChannel> channels;
        if (channel != null && event != null && (channels = this.channelMap.get(channel.getName())) != null) {
            ArrayList<iBroadcastChannel> channelsCopy = new ArrayList<iBroadcastChannel>(channels);
            channelsCopy.remove(channel);
            if (channelsCopy.size() > 0) {
                DispatchTask task = new DispatchTask(event, channelsCopy);
                try {
                    this.taskQueue.put(task);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            try {
                DispatchTask task = this.taskQueue.take();
                if (task != null) {
                    task.doTask();
                }
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

