/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.broadcastchannel.channel;

import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannel;
import com.immomo.luanative.broadcastchannel.channel.iBroadcastChannelListener;
import com.immomo.luanative.broadcastchannel.dispatcher.iBroadcastChannelDispatcher;
import com.immomo.luanative.broadcastchannel.event.MessageEventFactory;
import com.immomo.luanative.broadcastchannel.event.iMessageEvent;

public abstract class AbstractBroadcastChannel
implements iBroadcastChannel {
    private String name;
    private iBroadcastChannelListener listener;

    protected abstract iBroadcastChannelDispatcher getDispatcher();

    public AbstractBroadcastChannel(String name) {
        this.name = name;
    }

    @Override
    public void onMessage(iBroadcastChannelListener listener) {
        this.listener = listener;
    }

    @Override
    public <T> void postMessage(String action, T data) {
        iMessageEvent event = MessageEventFactory.getInstance(action, data);
        this.postMessage(event);
    }

    @Override
    public void postMessage(iMessageEvent event) {
        iBroadcastChannelDispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.notify(this, event);
        }
    }

    @Override
    public void close() {
        iBroadcastChannelDispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.remove(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void notify(iMessageEvent event) {
        if (this.listener != null) {
            this.listener.onMessage(event);
        }
    }

    protected void joinToDispatcher() {
        iBroadcastChannelDispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.join(this);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        iBroadcastChannelDispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.remove(this);
        }
    }
}

