/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.unity.vfs;

import com.immomo.emmylua.lua.unity.vfs.NetArchiveHandler;
import com.immomo.emmylua.lua.unity.vfs.NetFileSystem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0014J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/immomo/emmylua/lua/unity/vfs/NetFileSystem;", "Lcom/intellij/openapi/vfs/newvfs/ArchiveFileSystem;", "()V", "composeRootPath", "", "localPath", "extractLocalPath", "rootPath", "extractRootPath", "path", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileByPathIfCached", "getHandler", "Lcom/immomo/emmylua/lua/unity/vfs/NetArchiveHandler;", "entryFile", "getProtocol", "isCorrectFileType", "", "local", "refresh", "", "asynchronous", "refreshAndFindFileByPath", "Companion", "MMPaas"})
public final class NetFileSystem
extends ArchiveFileSystem {
    @NotNull
    public static final String PROTOCOL = "dll";
    @NotNull
    public static final String DLL_SEPARATOR = "!/";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (VirtualFile)VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
        String string = StringUtil.trimEnd((String)rootPath, (String)DLL_SEPARATOR);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.trimEnd(rootPath, DLL_SEPARATOR)");
        return string;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (VirtualFile)VfsImplUtil.findFileByPath((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (VirtualFile)VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    @NotNull
    protected NetArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        Intrinsics.checkParameterIsNotNull((Object)entryFile, (String)"entryFile");
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, (Function)getHandler.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)archiveHandler, (String)"VfsImplUtil.getHandler<N\u2026{ NetArchiveHandler(it) }");
        return (NetArchiveHandler)archiveHandler;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int separatorIndex = StringsKt.indexOf$default((CharSequence)path, (String)DLL_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        boolean bl2 = bl = separatorIndex >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Path passed to JarFileSystem must have jar separator '!/': " + path;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = path;
        int n = 0;
        int n2 = separatorIndex + DLL_SEPARATOR.length();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)((NewVirtualFileSystem)this), (boolean)asynchronous);
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        Intrinsics.checkParameterIsNotNull((Object)localPath, (String)"localPath");
        return localPath + DLL_SEPARATOR;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
        return super.isCorrectFileType(local) || Intrinsics.areEqual((Object)local.getExtension(), (Object)PROTOCOL);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/immomo/emmylua/lua/unity/vfs/NetFileSystem$Companion;", "", "()V", "DLL_SEPARATOR", "", "PROTOCOL", "instance", "Lcom/immomo/emmylua/lua/unity/vfs/NetFileSystem;", "getInstance", "()Lcom/immomo/emmylua/lua/unity/vfs/NetFileSystem;", "MMPaas"})
    public static final class Companion {
        @NotNull
        public final NetFileSystem getInstance() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(NetFileSystem.PROTOCOL);
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.unity.vfs.NetFileSystem");
            }
            return (NetFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

