/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.stubs;

import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.psi.LuaPsiFile;
import com.immomo.emmylua.lua.stubs.LuaFileStub;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/immomo/emmylua/lua/stubs/LuaFileElementType;", "Lcom/intellij/psi/tree/IStubFileElementType;", "Lcom/immomo/emmylua/lua/stubs/LuaFileStub;", "()V", "deserialize", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getBuilder", "Lcom/intellij/psi/StubBuilder;", "getExternalId", "", "parseContents", "Lcom/intellij/lang/ASTNode;", "chameleon", "serialize", "", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "Companion", "MMPaas"})
public final class LuaFileElementType
extends IStubFileElementType<LuaFileStub> {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        Intrinsics.checkParameterIsNotNull((Object)chameleon, (String)"chameleon");
        PsiElement psi = chameleon.getPsi();
        long t = System.currentTimeMillis();
        ASTNode contents = super.parseContents(chameleon);
        if (psi instanceof LuaPsiFile && LOG.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t;
            String string = ((LuaPsiFile)psi).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psi.name");
            String fileName = string;
            String string2 = fileName + " : " + dt;
            System.out.println((Object)string2);
            LOG.debug(fileName + " : " + dt);
        }
        return contents;
    }

    @NotNull
    public StubBuilder getBuilder() {
        return (StubBuilder)new DefaultStubBuilder(){
            private boolean isTooLarger;

            @NotNull
            protected StubElement<?> createStubForFile(@NotNull PsiFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (file instanceof LuaPsiFile) {
                    this.isTooLarger = ((LuaPsiFile)file).getTooLarger();
                    return (StubElement)new LuaFileStub((LuaPsiFile)file, ((LuaPsiFile)file).getModuleName());
                }
                StubElement stubElement = super.createStubForFile(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)stubElement, (String)"super.createStubForFile(file)");
                return stubElement;
            }

            public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                return this.isTooLarger;
            }
        };
    }

    public void serialize(@NotNull LuaFileStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stub), (String)"stub");
        Intrinsics.checkParameterIsNotNull((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getModule());
        if (LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder().append("--------- START: ");
            LuaPsiFile luaPsiFile = (LuaPsiFile)stub.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)luaPsiFile, (String)"stub.psi");
            String string = stringBuilder.append(luaPsiFile.getName()).toString();
            System.out.println((Object)string);
            string = stub.printTree();
            System.out.println((Object)string);
            StringBuilder stringBuilder2 = new StringBuilder().append("--------- END: ");
            LuaPsiFile luaPsiFile2 = (LuaPsiFile)stub.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)luaPsiFile2, (String)"stub.psi");
            string = stringBuilder2.append(luaPsiFile2.getName()).toString();
            System.out.println((Object)string);
        }
    }

    @NotNull
    public LuaFileStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkParameterIsNotNull((Object)dataStream, (String)"dataStream");
        StringRef moduleRef = dataStream.readName();
        return new LuaFileStub(null, StringRef.toString((StringRef)moduleRef));
    }

    @NotNull
    public String getExternalId() {
        return "llua.file";
    }

    public LuaFileElementType() {
        super((Language)LuaLanguage.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LuaFileElementType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LuaFileElementType::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/immomo/emmylua/lua/stubs/LuaFileElementType$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MMPaas"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

