/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.reference;

import com.immomo.emmylua.lua.psi.LuaElementFactory;
import com.immomo.emmylua.lua.psi.LuaNameExpr;
import com.immomo.emmylua.lua.psi.LuaPsiResolveUtilKt;
import com.immomo.emmylua.lua.reference.LuaReference;
import com.immomo.emmylua.lua.search.SearchContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/reference/LuaNameReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/immomo/emmylua/lua/psi/LuaNameExpr;", "Lcom/immomo/emmylua/lua/reference/LuaReference;", "element", "(Lcom/immomo/emmylua/lua/psi/LuaNameExpr;)V", "id", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getVariants", "", "", "()[Ljava/lang/Object;", "handleElementRename", "newElementName", "", "isReferenceTo", "", "resolve", "context", "Lcom/immomo/emmylua/lua/search/SearchContext;", "MMPaas"})
public final class LuaNameReference
extends PsiReferenceBase<LuaNameExpr>
implements LuaReference {
    private final PsiElement id;

    @NotNull
    public TextRange getRangeInElement() {
        int n = this.id.getTextOffset();
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        int start = n - ((LuaNameExpr)psiElement).getTextOffset();
        return new TextRange(start, start + this.id.getTextLength());
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkParameterIsNotNull((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        Project project = ((LuaNameExpr)psiElement).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        PsiElement newId = LuaElementFactory.INSTANCE.createIdentifier(project, newElementName);
        this.id.replace(newId);
        return newId;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        Project project = ((LuaNameExpr)psiElement).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        return this.resolve(SearchContext.Companion.get(project));
    }

    @Override
    @Nullable
    public PsiElement resolve(@NotNull SearchContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        PsiElement resolve2 = LuaPsiResolveUtilKt.resolve((LuaNameExpr)psiElement, context2);
        return resolve2 == (LuaNameExpr)this.myElement ? null : resolve2;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        return ((LuaNameExpr)psiElement).getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        return new Object[0];
    }

    public LuaNameReference(@NotNull LuaNameExpr element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super((PsiElement)element);
        PsiElement psiElement = element.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.id");
        this.id = psiElement;
    }
}

