/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.reference;

import com.immomo.emmylua.lua.psi.LuaElementFactory;
import com.immomo.emmylua.lua.psi.LuaIndexExpr;
import com.immomo.emmylua.lua.psi.LuaPsiResolveUtilKt;
import com.immomo.emmylua.lua.reference.LuaReference;
import com.immomo.emmylua.lua.search.SearchContext;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/reference/LuaIndexReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/immomo/emmylua/lua/psi/LuaIndexExpr;", "Lcom/immomo/emmylua/lua/reference/LuaReference;", "element", "id", "Lcom/intellij/psi/PsiElement;", "(Lcom/immomo/emmylua/lua/psi/LuaIndexExpr;Lcom/intellij/psi/PsiElement;)V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getVariants", "", "", "()[Ljava/lang/Object;", "handleElementRename", "newElementName", "", "isReferenceTo", "", "resolve", "context", "Lcom/immomo/emmylua/lua/search/SearchContext;", "MMPaas"})
public final class LuaIndexReference
extends PsiReferenceBase<LuaIndexExpr>
implements LuaReference {
    private final PsiElement id;

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode aSTNode = this.id.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"id.node");
        int n = aSTNode.getStartOffset();
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        ASTNode aSTNode2 = ((LuaIndexExpr)psiElement).getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"myElement.node");
        int start = n - aSTNode2.getStartOffset();
        return new TextRange(start, start + this.id.getTextLength());
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkParameterIsNotNull((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        Project project = ((LuaIndexExpr)psiElement).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        PsiElement newId = LuaElementFactory.INSTANCE.createIdentifier(project, newElementName);
        this.id.replace(newId);
        return newId;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        return ((LuaIndexExpr)psiElement).getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        Project project = ((LuaIndexExpr)psiElement).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        return this.resolve(SearchContext.Companion.get(project));
    }

    @Override
    @Nullable
    public PsiElement resolve(@NotNull SearchContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"myElement");
        PsiElement ref = LuaPsiResolveUtilKt.resolve((LuaIndexExpr)psiElement, context2);
        if (ref != null) {
            PsiFile psiFile = ref.getContainingFile();
            PsiElement psiElement2 = this.myElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myElement");
            if (Intrinsics.areEqual((Object)psiFile, (Object)((LuaIndexExpr)psiElement2).getContainingFile())) {
                ASTNode aSTNode = ref.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"ref.node");
                TextRange textRange = aSTNode.getTextRange();
                PsiElement psiElement3 = this.myElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"myElement");
                ASTNode aSTNode2 = ((LuaIndexExpr)psiElement3).getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"myElement.node");
                if (Intrinsics.areEqual((Object)textRange, (Object)aSTNode2.getTextRange())) {
                    return null;
                }
            }
        }
        return ref;
    }

    @NotNull
    public Object[] getVariants() {
        return new Object[0];
    }

    public LuaIndexReference(@NotNull LuaIndexExpr element, @NotNull PsiElement id) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        super((PsiElement)element);
        this.id = id;
    }
}

