/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.psi;

import com.immomo.emmylua.lua.psi.LuaClassMethod;
import com.immomo.emmylua.lua.psi.LuaLabelStat;
import com.immomo.emmylua.lua.search.SearchContext;
import com.immomo.emmylua.lua.ty.ITy;
import com.immomo.emmylua.lua.ty.Ty;
import com.immomo.emmylua.lua.ty.TyUnknown;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaPsiTreeUtil {
    private static final Class[] WS = new Class[]{PsiWhiteSpace.class};
    private static final Class[] WS_COMMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    public static void walkUpLabel(PsiElement current, Processor<LuaLabelStat> processor) {
        PsiElement prev = current.getPrevSibling();
        while (true) {
            if (prev == null) {
                prev = current.getParent();
            }
            if (prev == null || prev instanceof PsiFile || prev instanceof LuaLabelStat && !processor.process((Object)((LuaLabelStat)prev))) break;
            current = prev;
            prev = prev.getPrevSibling();
        }
    }

    public static <T extends PsiElement> void walkTopLevelInFile(PsiElement element, Class<T> cls, Processor<T> processor) {
        if (element == null || processor == null) {
            return;
        }
        PsiElement parent = element;
        while (!(parent.getParent() instanceof PsiFile)) {
            parent = parent.getParent();
        }
        for (PsiElement child = parent; child != null && (!cls.isInstance(child) || processor.process(cls.cast(child))); child = child.getPrevSibling()) {
        }
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart) {
        PsiElement t;
        if (file == null) {
            LuaPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            LuaPsiTreeUtil.$$$reportNull$$$0(1);
        }
        if ((t = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, clazz, (boolean)strictStart)) == null) {
            t = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), clazz, (boolean)strictStart);
        }
        return (T)t;
    }

    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, Class ... skips) {
        if (aClass == null) {
            LuaPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (skips == null) {
            LuaPsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return null;
        }
        for (element = element.getParent(); element != null && !aClass.isInstance(element) && PsiTreeUtil.instanceOf((Object)element, (Class[])skips); element = element.getParent()) {
            if (!(element instanceof PsiFile)) continue;
            return null;
        }
        return (T)((PsiElement)aClass.cast(element));
    }

    public static PsiElement skipWhitespacesBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])WS);
    }

    public static PsiElement skipWhitespacesAndCommentsBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])WS_COMMENTS);
    }

    public static PsiElement skipWhitespacesForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])WS);
    }

    public static PsiElement skipWhitespacesAndCommentsForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])WS_COMMENTS);
    }

    @NotNull
    public static ITy findContextClass(PsiElement current) {
        while (!(current instanceof PsiFile)) {
            if (current instanceof LuaClassMethod) {
                LuaClassMethod method = (LuaClassMethod)current;
                ITy iTy = method.guessParentType(SearchContext.Companion.get(current.getProject()));
                if (iTy == null) {
                    LuaPsiTreeUtil.$$$reportNull$$$0(4);
                }
                return iTy;
            }
            current = current.getParent();
        }
        TyUnknown tyUnknown = Ty.Companion.getUNKNOWN();
        if (tyUnknown == null) {
            LuaPsiTreeUtil.$$$reportNull$$$0(5);
        }
        return tyUnknown;
    }

    public static void processChildren(PsiElement parent, PsiElementProcessor<PsiElement> processor) {
        for (PsiElement child = parent.getFirstChild(); child != null && processor.execute(child); child = child.getNextSibling()) {
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skips";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/immomo/emmylua/lua/psi/LuaPsiTreeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/immomo/emmylua/lua/psi/LuaPsiTreeUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

